% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_data.R
\name{crop_data}
\alias{crop_data}
\alias{crop_data,Raster-method}
\alias{crop_data,data.table-method}
\alias{crop_data,character-method}
\title{Crop precipitation data sets}
\usage{
crop_data(x, y)

\S4method{crop_data}{Raster}(x, y)

\S4method{crop_data}{data.table}(x, y)

\S4method{crop_data}{character}(x, y)
}
\arguments{
\item{x}{Raster* object; data.table (see details); filename (character; see details)}

\item{y}{filename (character). Path to a *.shp file}
}
\value{
Raster* object; data.table
}
\description{
The function \code{crop_data} crops the data sets using a shapefile mask.
}
\details{
If `x` is a data.table, its columns should be named: "lon", "lat", "date", and "value"

If `x` is a filename, it should point to a *.nc file.
}
\examples{
\dontrun{
download_data("gldas-vic", tempdir(), timestep = "yearly")
r <- raster::brick(paste0(tempdir(),
"/gldas-vic_tp_mm_land_194801_201412_025_yearly.nc"))
s <- crop_data(r, "cze.shp")
}
}
