% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRep2.R
\name{pRep2}
\alias{pRep2}
\title{Second series of p-rep designs}
\usage{
pRep2(v, p)
}
\arguments{
\item{v}{Total number of treatments or breeding lines or entries}

\item{p}{positive integer (>=2)}
}
\value{
This function generates a new series of p-rep designs with parameters:

v = 10p   number of treatments,

e = 2     number of environments,

b = 10    blocks of size k = 3p and

r = 3     number of replications.

This function also generates canonical efficiency factor and average variance factor of the generated p-rep design.
}
\description{
For the specified values of v and p, this function generates the second series of p-rep designs. The input should meet the condition that v=10*p where, p>=2.
}
\examples{
library(pRepDesigns)
pRep2(20,2)
}
\references{
Williams E, Piepho HP, Whitaker D (2011)<https://doi.org/10.1002/bimj.201000102>
}
