% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_help_functions.R
\name{create_shorttable_from_gtsummary_compare_twogroups_timpoints}
\alias{create_shorttable_from_gtsummary_compare_twogroups_timpoints}
\title{Create a table to compare the descriptive analysis (short) from gtsummary of
two groups, but at different timepoints}
\usage{
create_shorttable_from_gtsummary_compare_twogroups_timpoints(
  variables,
  gtsummary,
  name_use,
  timepoints
)
}
\arguments{
\item{variables}{variables that interested}

\item{gtsummary}{a gtsummary object that contains summary parameters}

\item{name_use}{name of the variable or category}

\item{timepoints}{the timepoints at which the descriptive analysis is done}
}
\value{
the table
}
\description{
Create a table to compare the descriptive analysis (short) from gtsummary of
two groups, but at different timepoints
}
\examples{
eg_data <- as.data.frame(list(no = c(1, 2, 3, 4),
mark_at_1 = c(12, 34, 23, 45), gender = c("M", "F", "M", "F"),
mark_at_2 = c(12, 34, 23, 45)))
outcome_summary <- IPDFileCheck::get_summary_gtsummary(eg_data,
c("gender", "mark_at_1", "mark_at_2"), byvar = "gender")
variables <- "Mark"
k <- create_shorttable_from_gtsummary_compare_twogroups_timpoints(variables,
outcome_summary, "Category", c(1, 2))
}
