% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_loaded.R
\name{p_loaded}
\alias{p_isloaded}
\alias{p_loaded}
\title{Check for Loaded Packages}
\usage{
p_loaded(..., all = FALSE, char, character.only = FALSE)

p_isloaded(...)
}
\arguments{
\item{all}{logical.  If \code{TRUE} will show all packages 
including base install; \code{FALSE} will show all packages
excluding base install packages that install when R loads.}

\item{char}{Character vector containing packages to load.  If you are calling
\code{p_loaded} from within a function (or just having difficulties calling it 
using a character vector input) then pass your character vector of packages 
to load to this parameter directly.}

\item{character.only}{logical. If \code{TRUE} then \code{p_loaded} will only 
accept a single input which is a character vector containing the names of 
packages to load.}

\item{\ldots}{Optional package names.  Adding package names will check their 
individual load status.}
}
\description{
\code{p_loaded} - Output is a character string of loaded packages.

\code{p_isloaded} - Check if package(s) is loaded.
}
\examples{
\dontrun{
p_load(lattice, ggplot2)}
p_loaded()
p_loaded(all=TRUE)
p_loaded(ggplot2, tm, qdap)

p_isloaded(ggplot2)
p_isloaded(ggplot2, dfs, pacman)
\dontrun{p_unload(lattice)}
}
\seealso{
\code{\link[base]{.packages}},
\code{\link[utils]{sessionInfo}}
}
\keyword{loaded}
\keyword{packages}

