% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comapre.R
\name{pac_compare_versions}
\alias{pac_compare_versions}
\title{Compare DESCRIPTION files dependencies between specific packages versions}
\usage{
pac_compare_versions(
  pac,
  old,
  new,
  fields = c("Imports", "Depends", "LinkingTo")
)
}
\arguments{
\item{pac}{character a package name.}

\item{old}{character an old version of package.}

\item{new}{character a new version of package.}

\item{fields}{character a vector with possible values \code{c("Depends", "Imports", "LinkingTo", "Suggests")}. Default: \code{c("Depends", "Imports", "LinkingTo")}}
}
\value{
data.frame with 4 columns.
\describe{
\item{Package}{character package names.}
\item{Version.OLD}{character versions of dependencies required by an old package version.}
\item{Version.NEW}{character versions of dependencies required by a new package version.}
\item{version_status}{ numeric -1/0/1 which comes from \code{utils::compareVersion} function.
0 means that we have the same version as required by DESCRIPTION files. -1 means we have too low version installed, this is an error. 1 means we have higher version.}
}
}
\description{
using the remote CRAN mirror to compare DESCRIPTION files dependencies between specific packages versions.
}
\examples{
pac_compare_versions("memoise", "0.2.1", "2.0.0")
}
