% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{pac_deps}
\alias{pac_deps}
\title{package dependencies}
\usage{
pac_deps(
  pac,
  fields = c("Depends", "Imports", "LinkingTo"),
  lib.loc = .libPaths(),
  base = FALSE,
  local = TRUE,
  description_v = FALSE,
  attr = TRUE,
  recursive = TRUE,
  repos = "https://cran.rstudio.com/"
)
}
\arguments{
\item{pac}{character a package name.}

\item{fields}{character vector with possible values \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}. Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lib.loc}{character vector, used optionally when local is equal TRUE. Default: \code{.libPaths()}}

\item{base}{logical if to add base packages too. Default: FALSE}

\item{local}{logical if to use newest CRAN packages, where by default local ones are used. Default: TRUE}

\item{description_v}{if the dependencies version should be taken from description files, minimal required. Default: FALSE}

\item{attr}{logical specify if a package and its version should be added as a attribute of data.frame or for FALSE as a additional record. Default: TRUE}

\item{recursive}{logical if to assess the dependencies recursively. Default: TRUE}

\item{repos}{character the base URL of the CRAN repository to use. Used only for the validation. Default \verb{https://cran.rstudio.com/}}
}
\value{
data.frame with packages and their versions. Versions are taken from \code{installed.packages} or newest released.
}
\description{
Package dependencies from DESCRIPTION files with installed or expected versions or newest released.
}
\note{
When function is invoked in the loop afterwards binded results could be aggregated like,
\code{stats::aggregate(results[, c("Version"), drop = FALSE], list(Package = results$Package), pacs::compareVersionsMax)}.
}
\examples{
\dontrun{
pacs::pac_deps("stats", base = TRUE)$Package
pacs::pac_deps("memoise")$Package
pacs::pac_deps("memoise", description_v = FALSE)
# raw dependencies from DESCRIPTION file
pacs::pac_deps("memoise", description_v = TRUE, recursive = FALSE)
# raw dependencies from DESCRIPTION file - last release
pacs::pac_deps("memoise", description_v = TRUE, local = FALSE, recursive = FALSE)
}
}
