% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{pac_deps_dev}
\alias{pac_deps_dev}
\title{Package dependencies - developer perspective}
\usage{
pac_deps_dev(
  pac,
  base = FALSE,
  local = FALSE,
  attr = TRUE,
  repos = pacs::biocran_repos()
)
}
\arguments{
\item{pac}{\code{character} a package name.}

\item{base}{\code{logical} if to add base packages too. If \code{TRUE} then \code{pacs::pacs_base()} are taken into account. Default: \code{FALSE}}

\item{local}{\code{logical} if to use local repository (or newest remote packages). Default: \code{FALSE}}

\item{attr}{\code{logical} if a package and its version should be added as an attribute of data.frame or for FALSE as an additional record. Default: TRUE}

\item{repos}{\code{character} vector of repositories URLs to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}
}
\value{
\code{data.frame} with packages and their versions. Versions are taken from \code{installed.packages} or newest released.
}
\description{
A higher-level function, build from \code{pacs::pacs_deps}.
Package dependencies installed when e.g. \verb{R CMD check} a package.
\verb{"Depends", "Imports", "LinkingTo", "Suggests"} fields from the DESCRIPTION file and
their recursive dependencies taken from \verb{"Depends", "Imports", "LinkingTo"} fields.
Dependencies are taken remotely for the newest version.
}
\examples{
\dontrun{
pacs::pac_deps_dev("dplyr")
pacs::pac_deps_dev("pacs")
# with the main package in the list
pacs::pac_deps_dev("pacs", attr = FALSE)
}
}
