% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps_timemachine.R
\name{pac_deps_timemachine}
\alias{pac_deps_timemachine}
\title{R CRAN package dependencies for a certain version or time point}
\usage{
pac_deps_timemachine(
  pac,
  version = NULL,
  at = NULL,
  fields = c("Depends", "Imports", "LinkingTo"),
  recursive = TRUE
)
}
\arguments{
\item{pac}{character a package name.}

\item{version}{character version of package. Default: NULL}

\item{at}{Date old version of package. Default: NULL}

\item{fields}{a character vector listing the types of dependencies, a subset of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{recursive}{logical if to assess the dependencies recursively. Default: TRUE}
}
\value{
named vector package dependencies and their versions at the release date of main package plus one day.
}
\description{
Package dependencies from DESCRIPTION files retrieved recursively for certain version or time point.
}
\note{
Longer lived version is taken if 2 is available at the same date (switch time).
}
\examples{
\dontrun{
pacs::pac_deps_timemachine("memoise", "0.2.1")
pacs::pac_deps_timemachine("memoise", at = as.Date("2019-01-01"))
}
}
