% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{app_size}
\alias{app_size}
\title{Size of the shiny app}
\usage{
app_size(
  path = ".",
  fields = c("Depends", "Imports", "LinkingTo"),
  lib.loc = .libPaths(),
  recursive = TRUE
)
}
\arguments{
\item{path}{\code{character} path to the shiny app. Default: \code{"."}}

\item{fields}{\code{character} vector listing the types of dependencies, a subset of \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lib.loc}{\code{character} vector of search paths with local packages. Default: \code{.libPaths()}}

\item{recursive}{\code{logical} if to assess the dependencies recursively. Default: TRUE}
}
\value{
\code{numeric} size in bytes, to get MB ten divide by \code{10**6}.
}
\description{
The size of shiny app is a sum of dependencies packages and the app directory.
The app dependencies packages are checked recursively, and only in local repository.
The default arguments setup is recommended.
}
\note{
\code{renv} package has to be installed. \code{base} packages (\code{pacs::pacs_base()}) are not taken into account.
}
\examples{
\dontrun{
library(renv)
# Please update the path to the shiny app
cat(pacs::app_size(system.file("examples/04_mpg", package = "shiny")) / 10**6, "MB")
}
}
