% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pairsD3.R
\name{pairsD3}
\alias{pairsD3}
\title{D3 scatterplot matrices}
\usage{
pairsD3(x, group = NULL, subset = NULL, labels = NULL, cex = 3,
  width = NULL, col = NULL, big = FALSE, theme = "colour",
  opacity = 0.9)
}
\arguments{
\item{x}{the coordinates of points given as numeric columns of a
matrix or data frame. Logical and factor columns are converted
to numeric in the same way that \code{data.matrix} does.}

\item{group}{a optional vector specifying the group each observation
belongs to.  Used for tooltips and colouring the observations.}

\item{subset}{an optional vector specifying a subset of observations
to be used for plotting. Useful when you have a large number of
observations, you can specify a random subset.}

\item{labels}{the names of the variables (column names of \code{x}
used by default).}

\item{cex}{the magnification of the plotting symbol (default=3)}

\item{width}{the width (and height) of the plot when viewed externally.}

\item{col}{an optional (hex) colour for each of the levels in the group
vector.}

\item{big}{a logical parameter.  Prevents inadvertent plotting of huge
data sets.  Default limit is 10 variables, to plot more than 10 set
\code{big=TRUE}.}

\item{theme}{a character parameter specifying whether the theme should
be colour \code{colour} (default) or black and white \code{bw}.}

\item{opacity}{numeric between 0 and 1. The opacity of the plotting
  symbols (default 0.9).}
}
\description{
An interactive matrix of scatterplots is produced.
}
\examples{
data(iris)
\dontrun{
pairsD3(iris[,1:4],group=iris[,5],
         labels=gsub(pattern = "\\\\.",replacement = " ", names(iris)))
}
}

