% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simra.R
\name{simra}
\alias{simra}
\title{Simulate Response Pattern under Dichotomous and Polytomous Rasch Model}
\usage{
simra(itempar = matrix(seq(-2, 2, length = 5)), theta = 100,
  pers_obj = NULL, replicate = 1, seed = seq(1, replicate, 1), ...)
}
\arguments{
\item{itempar}{a "matrix" with \code{nrow = k} (number of items) and ncol = m (maximum number of thresholds), holding the 'thurstonian' thresholds of the respective item. Some of the rightmost matrix entries may be NA, depending on the number of categories of the respective item.}

\item{theta}{either one of the following (1) a numeric vector of length \code{n} providing the values of the person parameter (ability) for \code{n} persons to be used in the simulation. (2) a integer defining the number of values \code{n} to draw from N(0|1).}

\item{pers_obj}{an object of class \code{"pers"} as a result from function \code{\link{pers}}. If an object of class \code{"pers"} is assigned to this argument the model parameters in it are taken to simulate the responses. At default (\code{pers_obj = NULL}) simulation is done by considering the model parameters given in the other arguments (see above).}

\item{replicate}{an integer defining how many replicates (data matrices) \code{r} to draw based on the model parameters.}

\item{seed}{a numeric vector with legnth of number of replications used for \code{\link{set.seed}} prior to each replicate to keep the result repeatable. If \code{seed = NULL} no seed is set.}

\item{...}{arguments passed through.}
}
\value{
an array with \code{dim(n,k,r)} response patterns (\code{k} items in colums \code{n} persons in rows and \code{r} replications in the third dimension).
}
\description{
function for simulation of response patterns following the dichotomous and/or polytomous Rasch model based on the category probabilities given the model parameters.
At default, when just calling \code{simra()} 1 replication of responses to 5 items with difficulties -2, -1, 0, 1, 2 from 100 persons with ability drawn from N(0|1) are sampled.
}
\details{
no details in the moment.
}
\examples{
########
simra() # 100 dichotomous probabilistic response pattern
### 100 polytomous response pattern (4 items; each 4 answer categories)
v <- c(-1.0,-0.5,0.0,0.5,-0.75,-0.25,0.25,0.75,-0.5,0.0,0.5,1.0)
itempar <- matrix(v,nrow = 4,ncol = 3)
simra(itempar = itempar)
simra(itempar = itempar,replicate = 10) # draw 10 replications

}
