% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_comparisons.R
\name{pairwise_comparisons}
\alias{pairwise_comparisons}
\alias{pairwise_p}
\title{Multiple pairwise comparison tests}
\usage{
pairwise_comparisons(data, x, y, type = "parametric", tr = 0.1,
  paired = FALSE, var.equal = FALSE, p.adjust.method = "holm",
  k = 2, messages = TRUE, ...)

pairwise_p(data, x, y, type = "parametric", tr = 0.1, paired = FALSE,
  var.equal = FALSE, p.adjust.method = "holm", k = 2,
  messages = TRUE, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Current ignored.}
}
\value{
A tibble dataframe containing two columns corresponding to group
levels being compared with each other (\code{group1} and \code{group2}) and \code{p.value}
column corresponding to this comparison. The dataframe will also contain a
\code{p.value.label} column containing a \emph{label} for this \emph{p}-value, in case
this needs to be displayed in \code{geom_ggsignif}. In addition to these common
columns across the different types of statistics, there will be additional
columns specific to the \code{type} of test being run.

The \code{significance} column will display asterisks to indicate significance
of \emph{p}-values in the American Psychological Association (APA) mandated
format:
\itemize{
\item \code{ns} : > 0.05
\item \verb{*} : < 0.05
\item \verb{**} : < 0.01
\item \verb{***} : < 0.001
}
}
\description{
Calculate parametric, non-parametric, and robust pairwise
comparisons between group levels with corrections for multiple testing.
}
\examples{

\donttest{
# show all columns in a tibble
options(tibble.width = Inf)

#------------------- between-subjects design ----------------------------

# for reproducibility
set.seed(123)

library(pairwiseComparisons)

# parametric
# if `var.equal = TRUE`, then Student's *t*-test will be run
pairwise_comparisons(
  data = ggplot2::msleep,
  x = vore,
  y = brainwt,
  type = "parametric",
  var.equal = TRUE,
  paired = FALSE,
  p.adjust.method = "bonferroni"
)

# if `var.equal = FALSE`, then Games-Howell test will be run
pairwise_comparisons(
  data = ggplot2::msleep,
  x = vore,
  y = brainwt,
  type = "parametric",
  var.equal = FALSE,
  paired = FALSE,
  p.adjust.method = "bonferroni"
)

# non-parametric
pairwise_comparisons(
  data = ggplot2::msleep,
  x = vore,
  y = brainwt,
  type = "nonparametric",
  paired = FALSE,
  p.adjust.method = "none"
)

# robust
pairwise_comparisons(
  data = ggplot2::msleep,
  x = vore,
  y = brainwt,
  type = "robust",
  paired = FALSE,
  p.adjust.method = "fdr"
)

#------------------- within-subjects design ----------------------------

# for reproducibility
set.seed(123)

# parametric
pairwise_comparisons(
  data = bugs_long,
  x = condition,
  y = desire,
  type = "parametric",
  paired = TRUE,
  p.adjust.method = "BH"
)

# non-parametric
pairwise_comparisons(
  data = bugs_long,
  x = condition,
  y = desire,
  type = "nonparametric",
  paired = TRUE,
  p.adjust.method = "BY"
)

# robust
pairwise_comparisons(
  data = bugs_long,
  x = condition,
  y = desire,
  type = "robust",
  paired = TRUE,
  p.adjust.method = "hommel"
)
}
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}
}
