% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_intervals}
\alias{pbdb_intervals}
\title{Get information about multiple intervals}
\usage{
pbdb_intervals(...)
}
\arguments{
\item{...}{arguments passed to the API. See documentation for
accepted parameters at
\url{https://paleobiodb.org/data1.2/intervals/list}. E.g.:
\itemize{
\item \code{min_ma}: Return only intervals that are at least this old.
\item \code{max_ma}: Return only intervals that are at most this old.
\item \code{order}: Return the intervals in order starting as specified.
Possible values include \code{"age"}, \code{"name"}. Defaults to \code{"age"}.
\item \code{vocab}: Set to \code{"pbdb"} to show the complete name of the
variables (by default variables have short 3-letter names).
}}
}
\value{
A data frame with information from several temporal intervals.
}
\description{
Returns information about multiple intervals, selected according to
the parameters you provide.
}
\examples{
\dontrun{
  pbdb_intervals(min_ma = 0, max_ma = 2, vocab = "pbdb")
}
}
