% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfKruskal.R
\name{pfKruskal}
\alias{pfKruskal}
\title{Analyse composite records by a Kruskal-Wallis ANOVA}
\usage{
pfKruskal(data, p.adj = "none", alpha = 0.05, bins = NULL,
  verbose = TRUE)
}
\arguments{
\item{data}{An object returned by \code{\link[paleofire]{pfComposite}} or
\code{\link[paleofire]{pfTransform}}.}

\item{p.adj}{Method for adjusting p values (see
\code{\link[stats]{p.adjust}}). Includes: "holm", "hochberg", "hommel",
"bonferroni", "BH", "BY", "fdr" and "none" (default).}

\item{alpha}{Numeric, confidence level.}

\item{bins}{Numeric, bins to use if a "pfTransform" object is provided.}

\item{verbose}{Logical, verbose or not...}
}
\value{
A "pfKruskal" object containing multiple comparison results.
}
\description{
The function applies a Kruskal-Wallis ANOVA on binned data issued from a
"pfComposite" object (of directly on "pfTransform" objects), in order to
test the difference in biomass burning activity between different time
periods.
}
\examples{

## Composite charcoal record for Western Boreal North America:
ID=pfSiteSel(continent=="North America", long<(-100) & l12==1)
plot(ID)
## Transform data
res3=pfTransform(ID,method=c("MinMax","Box-Cox","Z-Score"),BasePeriod=c(200,4000))

## Composite
comp=pfComposite(res3,bins=seq(from=-500,to=12500,by=1000))
plot(comp)

## Kruskal Wallis Anova
comparison=pfKruskal(comp)

}
\seealso{
\code{\link{plot.pfKruskal}},\code{\link[agricolae]{kruskal}}
}
\author{
O. Blarquez
}
