% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vollenweider.R
\name{vollenweider_generate_regression_ETR_II}
\alias{vollenweider_generate_regression_ETR_II}
\title{Vollenweider Regression for ETR II}
\usage{
vollenweider_generate_regression_ETR_II(
  data,
  pmax_start_value = vollenweider_default_start_value_pmax,
  a_start_value = vollenweider_default_start_value_a,
  alpha_start_value = vollenweider_default_start_value_alpha,
  n_start_value = vollenweider_default_start_value_n
)
}
\arguments{
\item{data}{A \code{data.table} from \code{read_dual_pam_data}.}

\item{pmax_start_value}{Numeric. Initial value for \eqn{p_{max}}. Default: \code{pmax_start_values_vollenweider_default}.}

\item{a_start_value}{Numeric. Initial value for \eqn{a}. Default: \code{a_start_values_vollenweider_default}.}

\item{alpha_start_value}{Numeric. Initial value for \eqn{\alpha}. Default: \code{alpha_start_values_vollenweider_default}.}

\item{n_start_value}{Numeric. Initial value for \eqn{n}. Default: \code{n_start_values_vollenweider_default}.}
}
\value{
A list containing:
\itemize{
  \item \code{etr_regression_data}: Predicted ETR values.
  \item \code{sdiff}: Deviation between actual and predicted ETR.
  \item \code{pmax}: Maximum electron transport rate (\eqn{p_{max}}).
  \item \code{a}: Parameter \eqn{a}.
  \item \code{alpha}: Parameter \eqn{\alpha}.
  \item \code{n}: Parameter \eqn{n}.
  \item \code{popt}: Maximum electron transport rate with photoinhibition (\eqn{p_{opt}}).
  \item \code{ik}: Transition point from light limitation to light saturation without photoinhibition (\eqn{I_k}).
  \item \code{iik}: Transition point from light limitation to light saturation with photoinhibition (\eqn{I_k^\prime}).
  \item \code{pmax_popt_and_ik_iik_ratio}: Ratio of \eqn{p_{max}} to \eqn{p_{opt}} and \eqn{I_k} to \eqn{I_k^\prime}.
}
}
\description{
Fits the Vollenweider (1965) regression model using original naming conventions from the publication.
}
\details{
A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#vollenweider_generate_regression_etr_i-and-vollenweider_generate_regression_etr_ii}.
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "20240925.csv")
data <- read_dual_pam_data(path)

result <- vollenweider_generate_regression_ETR_II(data)

}
\references{
{
  Vollenweider, R. A. (1965). \emph{Calculation models of photosynthesis-depth curves and some implications regarding day rate estimates in primary production measurements},
  p. 427-457. In C. R. Goldman [ed.], \emph{Primary Productivity in Aquatic Environments}. Mem. Ist. Ital. Idrobiol., 18 Suppl., University of California Press, Berkeley.
}
}
