% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asym_gee.R
\name{asym_gee}
\alias{asym_gee}
\title{Asymmetric effects models fit with GEE}
\usage{
asym_gee(
  formula,
  data,
  id = NULL,
  wave = NULL,
  cor.str = c("ar1", "exchangeable", "unstructured"),
  use.wave = FALSE,
  wave.factor = FALSE,
  min.waves = 1,
  family = gaussian,
  weights = NULL,
  offset = NULL,
  ...
)
}
\arguments{
\item{formula}{Model formula. See details for crucial
info on \code{panelr}'s formula syntax.}

\item{data}{The data, either a \code{panel_data} object or \code{data.frame}.}

\item{id}{If \code{data} is not a \code{panel_data} object, then the name of the
individual id column as a string. Otherwise, leave as NULL, the default.}

\item{wave}{If \code{data} is not a \code{panel_data} object, then the name of the
panel wave column as a string. Otherwise, leave as NULL, the default.}

\item{cor.str}{Any correlation structure accepted by \code{\link[geepack:geeglm]{geepack::geeglm()}}.
Default is "ar1", most useful alternative is "exchangeable". "unstructured"
may cause problems due to its computational complexity.}

\item{use.wave}{Should the wave be included as a predictor? Default is
FALSE.}

\item{wave.factor}{Should the wave variable be treated as an unordered
factor instead of continuous? Default is FALSE.}

\item{min.waves}{What is the minimum number of waves an individual must
have participated in to be included in the analysis? Default is \code{2} and
any valid number is accepted. \code{"all"} is also acceptable if you want to
include only complete panelists.}

\item{family}{Use this to specify GLM link families. Default is \code{gaussian},
the linear model.}

\item{weights}{If using weights, either the name of the column in the data
that contains the weights or a vector of the weights.}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during
    fitting. This should be \code{NULL} or a numeric vector of length
    equal to the number of cases.  One or more \code{\link{offset}}
    terms can be included in the formula instead or as well, and if more
    than one is specified their sum is used.  See \code{\link{model.offset}}.}

\item{...}{Additional arguments provided to \code{\link[geepack:geeglm]{geepack::geeglm()}}.}
}
\value{
An \code{asym_gee} object, which inherits from \code{wbgee} and \code{geeglm}.
}
\description{
Fit "within-between" and several other regression variants
for panel data via generalized estimating equations.
}
\details{
See the documentation for \code{\link[=wbm]{wbm()}} for many details on formula syntax and
other arguments.
}
\examples{
data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
model <- asym_gee(lwage ~ lag(union) + wks, data = wages)
summary(model)

}
\references{
Allison, P. D. (2019). Asymmetric fixed-effects models for panel data.
\emph{Socius}, \emph{5}, 1-12. https://doi.org/10.1177/2378023119826441

McNeish, D. (2019). Effect partitioning in cross-sectionally clustered data
without multilevel models. \emph{Multivariate Behavioral Research},
Advance online publication. https://doi.org/10.1080/00273171.2019.1602504

McNeish, D., Stapleton, L. M., & Silverman, R. D. (2016). On the unnecessary
ubiquity of hierarchical linear modeling. \emph{Psychological Methods}, \emph{22},
114-140. https://doi.org/10.1037/met0000078
}
\author{
Jacob A. Long
}
