% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datafiles.R
\docType{data}
\name{Cigar}
\alias{Cigar}
\title{Cigar data}
\format{
The variables are:
\describe{
  \item{state}{State abbreviation}
  \item{year}{Year}
  \item{price}{Price per pack of cigarettes}
  \item{pop}{Population}
  \item{pop16}{Population above the age of 16.}
  \item{cpi}{Consumer price index with (1983=100}
  \item{ndi}{Per capita disposable income}
  \item{sales}{Cigarette sales in packs per capita}
  \item{pimin}{Minimum price in adjoining states per pack of cigarettes}

}

All variables all also available as logs.
}
\source{
\url{https://www.wiley.com/legacy/wileychi/baltagi/supp/Cigar.txt}
}
\usage{
Cigar
}
\description{
This panel data set consists of 46 U.S. States over the period 1963-1992.
}
\references{
Baltagi, B.H. and D. Levin (1992) "Cigarette taxation: raising revenues and reducing consumption", \emph{Structural Change and Economic Dynamics}, \strong{3}(2), 321-335, \doi{10.1016/0954-349X(92)90010-4}.

Baltagi, B.H., J.M. Griffin and W. Xiong (2000) "To pool or not to pool: homogeneous versus heterogeneous estimators applied to cigarette demand", \emph{Review of Economics and Statistics}, \strong{82}(1), 117-126, \doi{10.1162/003465300558551}.

Baltagi, B.H. (2013) "Econometric analysis of panel data", 5th edition, \emph{John Wiley and Sons}
Cigar
}
\keyword{datasets}
