% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BarFactory.R
\name{BarFactory}
\alias{BarFactory}
\title{BackendFactory}
\description{
This class is a factory that provides concrete implementations of the
\code{\link{Bar}} abstract class.
}
\examples{
# Create a bar factory.
bar_factory <- BarFactory$new()

# Get a modern bar instance.
bar <- bar_factory$get("modern")

# Check the class of the bar instance.
class(bar)

# Get a basic bar instance.
bar <- bar_factory$get("basic")

# Check the class of the bar instance.
class(bar)

}
\seealso{
\code{\link{Bar}}, \code{\link{BasicBar}}, and \code{\link{ModernBar}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BarFactory-get}{\code{BarFactory$get()}}
\item \href{#method-BarFactory-clone}{\code{BarFactory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BarFactory-get"></a>}}
\if{latex}{\out{\hypertarget{method-BarFactory-get}{}}}
\subsection{Method \code{get()}}{
Obtain a concrete implementation of the abstract \code{\link{Bar}}
class of the specified type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BarFactory$get(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{A character string specifying the type of the
\code{\link{Bar}} to instantiate. Possible values are \code{"modern"} and
\code{"basic"}. See the \strong{Details} section for more information.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
When \code{type = "modern"} a \code{\link{ModernBar}} instance is created
and returned. When \code{type = "basic"} a \code{\link{BasicBar}} instance
is provided instead.
}

\subsection{Returns}{
A concrete implementation of the class \code{\link{Bar}}. It throws an
error if the requested bar \code{type} is not supported.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BarFactory-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BarFactory-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BarFactory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
