% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicBar.R
\name{BasicBar}
\alias{BasicBar}
\title{BasicBar}
\description{
This is a concrete implementation of the abstract class \code{\link{Bar}}
using the \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}} as engine for the progress bar.
}
\examples{
# Create a basic bar instance.
bar <- BasicBar$new()

# Specify the number of ticks to be performed.
total <- 100

# Create the progress bar.
bar$create(total = total, initial = 0)

# Use the progress bar.
for (i in 1:total) {
    # Sleep a bit.
    Sys.sleep(0.02)

    # Update the progress bar.
    bar$update(i)
}

# Terminate the progress bar.
bar$terminate()

}
\seealso{
\code{\link{Bar}}, \code{\link{ModernBar}}, and \code{\link{BarFactory}}.
}
\section{Super class}{
\code{\link[parabar:Bar]{parabar::Bar}} -> \code{BasicBar}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BasicBar-new}{\code{BasicBar$new()}}
\item \href{#method-BasicBar-create}{\code{BasicBar$create()}}
\item \href{#method-BasicBar-update}{\code{BasicBar$update()}}
\item \href{#method-BasicBar-terminate}{\code{BasicBar$terminate()}}
\item \href{#method-BasicBar-clone}{\code{BasicBar$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasicBar-new"></a>}}
\if{latex}{\out{\hypertarget{method-BasicBar-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{\link{BasicBar}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasicBar$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{\link{BasicBar}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasicBar-create"></a>}}
\if{latex}{\out{\hypertarget{method-BasicBar-create}{}}}
\subsection{Method \code{create()}}{
Create a progress bar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasicBar$create(total, initial, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{total}}{The total number of times the progress bar should tick.}

\item{\code{initial}}{The starting point of the progress bar.}

\item{\code{...}}{Additional arguments for the bar creation passed to
\code{\link[utils:txtProgressBar]{utils::txtProgressBar()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The resulting bar is stored in the private
field \code{.bar}, accessible via the active binding \code{engine}. Both the
private field and the active binding are defined in the super class
\code{\link{Bar}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasicBar-update"></a>}}
\if{latex}{\out{\hypertarget{method-BasicBar-update}{}}}
\subsection{Method \code{update()}}{
Update the progress bar by calling \code{\link[utils:txtProgressBar]{utils::setTxtProgressBar()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasicBar$update(current)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{current}}{The position the progress bar should be at (e.g., 30
out of 100), usually the index in a loop.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasicBar-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-BasicBar-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the progress bar by calling \code{\link[base:connections]{base::close()}} on the
private field \code{.bar}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasicBar$terminate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasicBar-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BasicBar-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasicBar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
