% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_design_sobol.R
\name{generate_design_sobol}
\alias{generate_design_sobol}
\title{Generate a Space-Filling Sobol Sequence Design}
\usage{
generate_design_sobol(param_set, n)
}
\arguments{
\item{param_set}{(\link{ParamSet}).}

\item{n}{(\code{integer(1)}) \cr
Number of points to sample.}
}
\value{
\link{Design}.
}
\description{
Generate a space-filling design using a Sobol sequence. Dependent
parameters whose constraints are unsatisfied generate \code{NA} entries in
their respective columns.

Uses \link[spacefillr:generate_sobol_set]{spacefillr::generate_sobol_set}.

Note that non determinism is achieved by sampling the seed argument via
\code{sample(.Machine$integer.max, size = 1L)}.
}
\examples{
ps = ParamSet$new(list(
  ParamDbl$new("ratio", lower = 0, upper = 1),
  ParamFct$new("letters", levels = letters[1:3])
))

if (requireNamespace("spacefillr", quietly = TRUE)) {
  generate_design_sobol(ps, 10)
}
}
\seealso{
Other generate_design: 
\code{\link{generate_design_grid}()},
\code{\link{generate_design_lhs}()},
\code{\link{generate_design_random}()}
}
\concept{generate_design}
