% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Param.R
\name{Param}
\alias{Param}
\title{Param Class}
\description{
This is the abstract base class for parameter objects like \link{ParamDbl} and
\link{ParamFct}.
}
\section{S3 methods}{

\itemize{
\item \code{as.data.table()}\cr
\link{Param} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Converts param to \code{\link[data.table:data.table]{data.table::data.table()}} with 1 row. See \link{ParamSet}.
}
}

\seealso{
Other Params: 
\code{\link{ParamDbl}},
\code{\link{ParamFct}},
\code{\link{ParamInt}},
\code{\link{ParamLgl}},
\code{\link{ParamUty}}
}
\concept{Params}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the object.}

\item{\code{special_vals}}{(\code{list()})\cr
Arbitrary special values this parameter is allowed to take.}

\item{\code{default}}{(\code{any})\cr
Default value.}

\item{\code{tags}}{(\code{character()})\cr
Arbitrary tags to group and subset parameters.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{class}}{(\code{character(1)})\cr
R6 class name. Read-only.}

\item{\code{is_number}}{(\code{logical(1)})\cr
\code{TRUE} if the parameter is of type \code{"dbl"} or \code{"int"}.}

\item{\code{is_categ}}{(\code{logical(1)})\cr
\code{TRUE} if the parameter is of type \code{"fct"} or \code{"lgl"}.}

\item{\code{has_default}}{(\code{logical(1)})\cr
Is there a default value?}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Param$new()}}
\item \href{#method-check}{\code{Param$check()}}
\item \href{#method-assert}{\code{Param$assert()}}
\item \href{#method-test}{\code{Param$test()}}
\item \href{#method-rep}{\code{Param$rep()}}
\item \href{#method-format}{\code{Param$format()}}
\item \href{#method-print}{\code{Param$print()}}
\item \href{#method-qunif}{\code{Param$qunif()}}
\item \href{#method-clone}{\code{Param$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.

Note that this object is typically constructed via derived classes,
e.g., \link{ParamDbl}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Param$new(id, special_vals, default, tags)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of the object.}

\item{\code{special_vals}}{(\code{list()})\cr
Arbitrary special values this parameter is allowed to take, to make it
feasible. This allows extending the domain of the parameter. Note that
these values are only used in feasibility checks, neither in generating
designs nor sampling.}

\item{\code{default}}{(\code{any})\cr
Default value. Can be from the domain of the parameter or an element of
\code{special_vals}. Has value \link{NO_DEF} if no default exists. \code{NULL} can be a
valid default.}

\item{\code{tags}}{(\code{character()})\cr
Arbitrary tags to group and subset parameters. Some tags serve a special
purpose:\cr
\itemize{
\item \code{"required"} implies that the parameters has to be given when setting
\code{values} in \link{ParamSet}.
}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check"></a>}}
\if{latex}{\out{\hypertarget{method-check}{}}}
\subsection{Method \code{check()}}{
\pkg{checkmate}-like check-function. Take a value from the domain of the
parameter, and check if it is feasible. A value is feasible if it is of
the same \code{storage_type}, inside of the bounds or element of
\code{special_vals}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Param$check(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\code{any}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{TRUE}, if not a string with the error message.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-assert"></a>}}
\if{latex}{\out{\hypertarget{method-assert}{}}}
\subsection{Method \code{assert()}}{
\pkg{checkmate}-like assert-function. Take a value from the domain of
the parameter, and assert if it is feasible. A value is feasible if it
is of the same \code{storage_type}, inside of the bounds or element of
\code{special_vals}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Param$assert(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\code{any}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{x} invisibly, if not an error message.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-test"></a>}}
\if{latex}{\out{\hypertarget{method-test}{}}}
\subsection{Method \code{test()}}{
\pkg{checkmate}-like test-function. Take a value from the domain of the
parameter, and test if it is feasible. A value is feasible if it is of
the same \code{storage_type}, inside of the bounds or element of
\code{special_vals}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Param$test(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\code{any}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If successful \code{TRUE}, if not \code{FALSE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rep"></a>}}
\if{latex}{\out{\hypertarget{method-rep}{}}}
\subsection{Method \code{rep()}}{
Repeats this parameter n-times (by cloning).
Each parameter is named "[id]\emph{rep}[k]" and gets the additional tag "[id]_rep".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Param$rep(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{ParamSet}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Param$format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Param$print(
  ...,
  hide_cols = c("nlevels", "is_bounded", "special_vals", "tags", "storage_type")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}

\item{\code{hide_cols}}{(\code{character()})\cr
Which fields should not be printed? Default is \code{"nlevels"},
\code{"is_bounded"}, \code{"special_vals"}, \code{"tags"}, and \code{"storage_type"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-qunif"></a>}}
\if{latex}{\out{\hypertarget{method-qunif}{}}}
\subsection{Method \code{qunif()}}{
Takes values from [0,1] and maps them, regularly distributed, to the
domain of the parameter. Think of: quantile function or the use case to
map a uniform-[0,1] random variable into a uniform sample from this
param.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Param$qunif(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\code{numeric(1)}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of the domain of the parameter.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Param$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
