% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{JWriteBin}
\alias{JWriteBin}
\title{JWriteBin}
\usage{
JWriteBin(M, fname, dtype = "float", dmtype = "full", comment = "")
}
\arguments{
\item{M}{The R matrix to be written}

\item{fname}{The name of the file to write}

\item{dtype}{The data type of the matrix to be written: one of the strings 'short', 'int', 'long', 'float' or 'double'. Default: 'float'}

\item{dmtype}{The matrix type: one of the strings 'full', 'sparse' or 'symmetric'. Default: 'full'}

\item{comment}{A optional string with the comment to be added as metadata. Default: "" (empty string, no added comment)}
}
\value{
No return value, called for side effects (creates a file)
}
\description{
Writes a R matrix to a disk file as a binary matrix in the jmatrix format
}
\details{
Use this function cautiously. Differently to the functions to get one or more rows or columns from the binary file,
which book only the memory strictly needed for the vector/matrix and do not load all the binary file in memory,
this function books the full matrix in the requested data type and writes it later so with very big matrices
you might run out of memory.\cr
Type 'int' is really long int (8-bytes in most modern machines) so using 'int' or 'long' is equivalent.\cr
Type is coerced from double (the internal type of R matrices) to the requested type, which may provoke a loose of precision.\cr
If M is a named-R matrix, row and column names are written as metadata, too.\cr
Also, if you write as symmetric a matrix which is not such, only the lower-diagonal part will be written.
The rest of the data will be lost. In this case, if the matrix has row and column names, only row names are written.
}
\examples{
Rf <- matrix(runif(48),nrow=6)
rownames(Rf) <- c("A","B","C","D","E","F")
colnames(Rf) <- c("a","b","c","d","e","f","g","h")
JWriteBin(Rf,"Rfullfloat.bin",dtype="float",dmtype="full",comment="Full matrix of floats")
file.remove("Rfullfloat.bin")
}
