% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.models.R
\name{standardize.lm}
\alias{standardize.lm}
\title{Model Standardization}
\usage{
\method{standardize}{lm}(x, robust = FALSE, method = "default",
  verbose = TRUE, ...)
}
\arguments{
\item{x}{Object.}

\item{robust}{Logical, if \code{TRUE}, centering is done by substracting the
median from the variables and divide it by the median absolute deviation
(MAD). If \code{FALSE}, variables are standardized by substracting the
mean and divide it by the standard deviation (SD).
the}

\item{method}{The method of standardization. For data.frames, can be \code{"default"} (variables are divided by SD or MAD depending on \code{robust}) or \code{"2sd"} (divided by two times the deviation).}

\item{verbose}{Toggle warnings on or off.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
The model fitted on standardized data.
}
\description{
Refit the model after standardizing the data.
}
\examples{
model <- lm(Sepal.Length ~ Species * Petal.Width, data = iris)
coef(standardize(model))
}
