% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_cgam.R, R/methods_gam.R,
%   R/methods_quantreg.R
\name{model_parameters.cgam}
\alias{model_parameters.cgam}
\alias{model_parameters.gam}
\alias{model_parameters.rqss}
\title{Parameters from Generalized Additive (Mixed) Models}
\usage{
\method{model_parameters}{cgam}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  robust = FALSE,
  p_adjust = NULL,
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{gam}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  robust = FALSE,
  p_adjust = NULL,
  parameters = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{rqss}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  robust = FALSE,
  p_adjust = NULL,
  parameters = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A gam/gamm model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{bootstrap}{Should estimates be based on bootstrapped model? If
\code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian
regressions} apply (see also
\code{\link[=bootstrap_parameters]{bootstrap_parameters()}}).}

\item{iterations}{The number of bootstrap replicates. This only apply in the
case of bootstrapped frequentist models.}

\item{standardize}{The method used for standardizing the parameters. Can be
\code{"refit"}, \code{"posthoc"}, \code{"smart"}, \code{"basic"},
\code{"pseudo"} or \code{NULL} (default) for no standardization. See
'Details' in \code{\link[effectsize]{standardize_parameters}}.
\strong{Important:} Categorical predictors (i.e. factors) are \emph{never}
standardized by default, which may be a different behaviour compared to
other R packages or other software packages (like SPSS). If standardizing
categorical predictors is desired, either use \code{standardize="basic"}
to mimic behaviour of SPSS or packages such as \pkg{lm.beta}, or standardize
the data with \code{effectsize::standardize(force=TRUE)} before fitting
the model. Robust estimation (i.e. \code{robust=TRUE}) of standardized
parameters only works when \code{standardize="refit"}.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
the coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log
or logit links. \strong{Note:} Delta-method standard errors are also
computed (by multiplying the standard errors by the transformed
coefficients). This is to mimic behaviour of other software packages, such
as Stata, but these standard errors poorly estimate uncertainty for the
transformed coefficient. The transformed confidence interval more clearly
captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients
from non-Gaussian families.}

\item{robust}{Logical, if \code{TRUE}, robust standard errors are calculated
(if possible), and confidence intervals and p-values are based on these
robust standard errors. Additional arguments like \code{vcov_estimation} or
\code{vcov_type} are passed down to other methods, see
\code{\link[=standard_error_robust]{standard_error_robust()}} for details
and \href{https://easystats.github.io/parameters/articles/model_parameters_robust.html}{this vignette}
for working examples.}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to
adjust p-values. See \code{\link[stats]{p.adjust}} for details. Further
possible adjustment methods are \code{"tukey"}, \code{"scheffe"},
\code{"sidak"} and \code{"none"} to explicitly disable adjustment for
\code{emmGrid} objects (from \pkg{emmeans}).}

\item{parameters}{Character vector of length 1 with a regular expression pattern
that describes the parameters that should be returned from the data frame, or
a named list of regular expressions. All non-matching parameters will be
removed from the output. If \code{parameters} is a character vector, every
parameter in the \emph{"Parameters"} column that matches the regular expression in
\code{parameters} will be selected from the returned data frame. Furthermore,
if \code{parameters} has more than one element, these will be merged into
a regular expression pattern like this: \code{"(one|two|three)"}. If
\code{parameters} is a named list of regular expression patterns, the
names of the list-element should equal the column name where selection
should be applied. This is useful for model objects where
\code{model_parameters()} returns multiple columns with parameter components,
like in \code{\link{model_parameters.lavaan}}.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods. For instance, when
\code{bootstrap = TRUE}, arguments like \code{type} or \code{parallel} are
passed down to \code{bootstrap_model()}, and arguments like \code{ci_method}
are passed down to \code{\link[bayestestR]{describe_posterior}}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Extract and compute indices and measures to describe parameters
  of generalized additive models (GAM(M)s).
}
\details{
The reporting of degrees of freedom \emph{for the spline terms}
slightly differs from the output of \code{summary(model)}, for example in the
case of \code{mgcv::gam()}. The \emph{estimated degrees of freedom}, column
\code{edf} in the summary-output, is named \code{df} in the returned data
frame, while the column \code{df_error} in the returned data frame refers to
the residual degrees of freedom that are returned by \code{df.residual()}.
Hence, the values in the the column \code{df_error} differ from the column
\code{Ref.df} from the summary, which is intentional, as these reference
degrees of freedom \dQuote{is not very interpretable}
(\href{https://r.789695.n4.nabble.com/ref-df-in-mgcv-gam-tp4756194p4756195.html}{web}).
}
\examples{
library(parameters)
if (require("mgcv")) {
  dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
  model <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat)
  model_parameters(model)
}
}
\seealso{
\code{\link[insight:standardize_names]{standardize_names()}} to rename
  columns into a consistent, standardized naming scheme.
}
