% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_averaging.R, R/methods_betareg.R,
%   R/methods_glmx.R
\name{model_parameters.averaging}
\alias{model_parameters.averaging}
\alias{model_parameters.betareg}
\alias{model_parameters.glmx}
\title{Parameters from special models}
\usage{
\method{model_parameters}{averaging}(
  model,
  ci = 0.95,
  component = c("conditional", "full"),
  exponentiate = FALSE,
  p_adjust = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{betareg}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  component = c("conditional", "precision", "all"),
  standardize = NULL,
  exponentiate = FALSE,
  p_adjust = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{glmx}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  component = c("all", "conditional", "extra"),
  standardize = NULL,
  exponentiate = FALSE,
  p_adjust = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{Model object.}

\item{ci}{Confidence Interval (CI) level. Default to \code{0.95} (\verb{95\%}).}

\item{component}{Model component for which parameters should be shown. May be
one of \code{"conditional"}, \code{"precision"} (\pkg{betareg}),
\code{"scale"} (\pkg{ordinal}), \code{"extra"} (\pkg{glmx}),
\code{"marginal"} (\pkg{mfx}), \code{"conditional"} or \code{"full"} (for
\code{MuMIn::model.avg()}) or \code{"all"}.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
the coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log
or logit links. \strong{Note:} Delta-method standard errors are also
computed (by multiplying the standard errors by the transformed
coefficients). This is to mimic behaviour of other software packages, such
as Stata, but these standard errors poorly estimate uncertainty for the
transformed coefficient. The transformed confidence interval more clearly
captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients
from non-Gaussian families.}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to
adjust p-values. See \code{\link[stats:p.adjust]{stats::p.adjust()}} for details. Further
possible adjustment methods are \code{"tukey"}, \code{"scheffe"},
\code{"sidak"} and \code{"none"} to explicitly disable adjustment for
\code{emmGrid} objects (from \pkg{emmeans}).}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods. For instance, when
\code{bootstrap = TRUE}, arguments like \code{type} or \code{parallel} are
passed down to \code{bootstrap_model()}, and arguments like \code{ci_method}
are passed down to \code{\link[bayestestR:describe_posterior]{bayestestR::describe_posterior()}}.}

\item{bootstrap}{Should estimates be based on bootstrapped model? If
\code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply (see also
\code{\link[=bootstrap_parameters]{bootstrap_parameters()}}).}

\item{iterations}{The number of bootstrap replicates. This only apply in the
case of bootstrapped frequentist models.}

\item{standardize}{The method used for standardizing the parameters. Can be
\code{NULL} (default; no standardization), \code{"refit"} (for re-fitting the model
on standardized data) or one of \code{"basic"}, \code{"posthoc"}, \code{"smart"},
\code{"pseudo"}. See 'Details' in \code{\link[effectsize:standardize_parameters]{effectsize::standardize_parameters()}}.
\strong{Important:}
\itemize{
\item The \code{"refit"} method does \emph{not} standardized categorical predictors (i.e.
factors), which may be a different behaviour compared to other R packages
(such as \pkg{lm.beta}) or other software packages (like SPSS). to mimic
such behaviours, either use \code{standardize="basic"} or standardize the data
with \code{datawizard::standardize(force=TRUE)} \emph{before} fitting the model.
\item For mixed models, when using methods other than \code{"refit"}, only the fixed
effects will be returned.
\item Robust estimation (i.e. \code{robust=TRUE}) of standardized parameters only
works when \code{standardize="refit"}.
}}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters from special regression models not listed under one of the previous categories yet.
}
\examples{
library(parameters)
if (require("brglm2", quietly = TRUE)) {
  data("stemcell")
  model <- bracl(
    research ~ as.numeric(religion) + gender,
    weights = frequency,
    data = stemcell,
    type = "ML"
  )
  model_parameters(model)
}
}
\seealso{
\code{\link[insight:standardize_names]{insight::standardize_names()}} to rename
columns into a consistent, standardized naming scheme.
}
