% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_BayesFactor.R
\name{p_value.BFBayesFactor}
\alias{p_value.BFBayesFactor}
\title{p-values for Bayesian Models}
\usage{
\method{p_value}{BFBayesFactor}(model, ...)
}
\arguments{
\item{model}{A statistical model.}

\item{...}{Additional arguments}
}
\value{
The p-values.
}
\description{
This function attempts to return, or compute, p-values of Bayesian models.
}
\details{
For Bayesian models, the p-values corresponds to the \emph{probability of
direction} (\code{\link[bayestestR:p_direction]{bayestestR::p_direction()}}), which is converted to a p-value
using \code{bayestestR::convert_pd_to_p()}.
}
\examples{
data(iris)
model <- lm(Petal.Length ~ Sepal.Length + Species, data = iris)
p_value(model)
}
