% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\alias{normalize.numeric}
\alias{normalize.grouped_df}
\alias{normalize.data.frame}
\title{Normalization}
\usage{
normalize(x, ...)

\method{normalize}{numeric}(x, include_bounds = TRUE, verbose = TRUE,
  ...)

\method{normalize}{grouped_df}(x, select = NULL, exclude = NULL,
  include_bounds = TRUE, ...)

\method{normalize}{data.frame}(x, select = NULL, exclude = NULL,
  include_bounds = TRUE, ...)
}
\arguments{
\item{x}{Object.}

\item{...}{Arguments passed to or from other methods.}

\item{include_bounds}{Logical, if \code{TRUE}, return value may include 0
and 1. If \code{FALSE}, the return value is compressed, using the formula
\code{(x * (n - 1) + 0.5) / n} (\cite{Smithson and Verkuilen 2006}), to
avoid zeros and ones in the normalized variables. This can be useful in
case of beta-regression, where the response variable is not allowed to
include zeros and ones.}

\item{verbose}{Toggle warnings on or off.}

\item{select}{For a data frame, character vector of column names to be
standardized. If \code{NULL} (the default), all variables will be
standardized.}

\item{exclude}{For a data frame, character vector of column names to
be excluded from standardization.}
}
\value{
A normalized object.
}
\description{
Performs a normalization of data. This scales all numeric variables in the range 0 - 1.
}
\references{
Smithson M, Verkuilen J (2006). A Better Lemon Squeezer? Maximum-Likelihood Regression with Beta-Distributed Dependent Variables. Psychological Methods, 11(1), 54–71.
}
