% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewness_kurtosis.R
\name{skewness}
\alias{skewness}
\alias{kurtosis}
\title{Compute Skewness and Kurtosis}
\usage{
skewness(x, na.rm = TRUE, ...)

kurtosis(x, ...)
}
\arguments{
\item{x}{A numeric vector or data.frame.}

\item{na.rm}{Remove missing values.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
Values of skewness or kurtosis.
}
\description{
Compute Skewness and Kurtosis
}
\details{
\strong{Skewness}
\cr \cr
Symmetric distributions have a \code{skewness} around zero, while
a negative skewness values indicates a "left-skewed" distribution, and a
positive skewness values indicates a "right-skewed" distribution. Examples
for the relationship of skewness and distributions are:
\itemize{
  \item Normal distribution (and other symmetric distribution) has a skewness of 0
  \item Half-normal distribution has a skewness just below 1
  \item Exponential distribution has a skewness of 2
  \item Lognormal distribution can have a skewness of any positive value, depending on its parameters
}
(\cite{https://en.wikipedia.org/wiki/Skewness})
\cr \cr
\strong{Kurtosis}
\cr \cr
The \code{kurtosis} is a measure of "tailedness" of a distribution. A distribution
with a kurtosis values of about zero is called "mesokurtic". A kurtosis value
larger than zero indicates a "leptokurtic" distribution with \emph{fatter} tails.
A kurtosis value below zero indicates a "platykurtic" distribution with \emph{thinner}
tails (\cite{https://en.wikipedia.org/wiki/Kurtosis}).
}
\examples{
skewness(rnorm(1000))
kurtosis(rnorm(1000))
}
