% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mps_on_date.R
\name{mps_on_date}
\alias{mps_on_date}
\title{Request information on all MPs who were members of the House of Commons on the date specificed (if only one date is included as a parameter), or on or between the two dates if two are specified. Includes constituency and electoral information if the date is 2010-05-06 or later, or if the date range is entirely within 2010-05-06 and the present day.}
\usage{
mps_on_date(date1 = Sys.Date(), date2 = NULL, tidy = TRUE)
}
\arguments{
\item{date1}{The date to return the list of mps from. Defaults to current system date.}

\item{date2}{An optional query parameter. If a proper date in "YYYY-MM-DD" format, the function returns a list of all MPs who were members between date2 and date1. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove extra characters, superfluous text and convert variable names to snake_case. Defaults to TRUE.}
}
\value{
A tibble with information on all MPs who were members of the House of Commons on the date specificed (if only date1 is included as a parameter), or on or between the two dates if both date1 and date2 are specified.
}
\description{
Request information on all MPs who were members of the House of Commons on the date specificed (if only one date is included as a parameter), or on or between the two dates if two are specified. Includes constituency and electoral information if the date is 2010-05-06 or later, or if the date range is entirely within 2010-05-06 and the present day.
}
\examples{
\dontrun{

x <- mps_on_date()

}
}
