% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableRule.R
\name{tableRule}
\alias{tableRule}
\alias{find_rules}
\alias{rules}
\alias{find_rule}
\alias{rule}
\alias{rule<-}
\title{Work with rules in tables}
\usage{
find_rules(table)

rules(table)

find_rule(table, row)

rule(table, row)

rule(table, row, asis = FALSE) <- value
}
\arguments{
\item{table}{A tabular-like environment to work with.}

\item{row}{The rules will precede the contents of this row.
The rule after the final row uses \code{row = tableNrow(table) + 1}.}

\item{asis}{Should a newline be added after the
value?  If \code{asis = TRUE}, it will not be.}

\item{value}{The content to be inserted into the cell.  This
can be a \link{LaTeX2} object, or a character string that will be
converted to one.}
}
\value{
\code{find_rules()} returns a list of the indices
of rules before each row, including the whitespace
following each one.

\code{rules(table)} returns a list of the rules
before each row.  The last entry will be the rule(s)
following the last row.

\code{find_rule(table, row)} returns the indices
of the rule(s) before \code{row}.

\code{rule(table, row)} returns the indices
rule(s) before \code{row}.
}
\description{
In LaTeX, "rules" are horizontal lines in a table.
These functions let rules be extracted or modified.
}
\examples{
latex <- kableExtra::kbl(mtcars[1:2, 1:2], format = "latex")
parsed <- parseLatex(latex)
table <- parsed[[find_tabular(parsed)]]
table
find_rules(table)

rules(table)

find_rule(table, 1)

rule(table, 1)

rule(table, 2) <- "\\\\midrule"
table
}
