% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finders.R
\name{find_pattern}
\alias{find_pattern}
\title{Find a pattern in deparsed items}
\usage{
find_pattern(items, pattern, ..., all = FALSE)
}
\arguments{
\item{items}{A list of latex items.}

\item{pattern}{Pattern to use in \code{grepl()}.}

\item{...}{Additional parameters to pass to \code{grepl}.}

\item{all}{Find all matching, or the first?}
}
\value{
\code{find_pattern()} returns a \link{LaTeX2range} object
or (if \code{all} is \code{TRUE}) a list of them.
}
\description{
Searches a \link{LaTeX2} list for text using \code{grepl()} on deparsed versions of parts of the code.
It attempts to find the narrowest match(es) that lie
within a single container.
}
\details{
\code{find_pattern()} does a recursive search in the order
items appear in the deparse.  If the pattern matches,
it attempts to narrow the match by recursing into
containers and dropping earlier and later items.
It should always return syntactically correct LaTeX
code in which the pattern appears.
}
\examples{
latex <- kableExtra::kbl(mtcars[1:2, 1:2], format = "latex", caption = "Sample table")
parsed <- parseLatex(latex)
parsed
loc <- find_pattern(parsed, "RX4 Wag", fixed = TRUE)
loc
print(loc, source = parsed)
}
