#' @name data_dia
#'
#' @title Example of processed dia.txt output from RPDR using the load_dia() function.
#'
#' @description Result of a dia.txt output from RPDR loaded into a data table in R using \emph{load_dia()}.
#'
#' **NOTE**: Due to potential issues with PHI and PPI, the example datasets can be downloaded from the
#' Partners Gitlab repository under *parserpdr-sample-data*.
#'
#' @docType data
#'
#' @usage data_dia
#'
#' @format data.table
#'
#' @return data table, with diagnoses information.
#' \describe{
#'  \item{ID_MERGE}{numeric, defined IDs by \emph{merge_id}, used for merging later.}
#'  \item{ID_dia_EMPI}{string, Unique Partners-wide identifier assigned to the patient used to consolidate patient information
#'  from \emph{dia} datasource, corresponds to EMPI in RPDR. Data is formatted using pretty_mrn().}
#'  \item{ID_dia_PMRN}{string, Epic medical record number. This value is unique across Epic instances within the Partners network
#'  from \emph{dia} datasource, corresponds to EPIC_PMRN in RPDR. Data is formatted using pretty_mrn().}
#'  \item{ID_dia_loc}{string, if mrn_type == TRUE, then the data in \emph{MRN_Type} and \emph{MRN} are parsed into IDs corresponding to locations \emph{(loc)}. Data is formatted using pretty_mrn().}
#'  \item{time_dia}{POSIXct, Date when the diagnosis was noted, corresponds to Date in RPDR. Converted to POSIXct format.}
#'  \item{dia_name}{string, Name of the diagnosis, diagnosis-related group, or phenotype. For more information on available
#'  Phenotypes visit https://phenotypes.partners.org/phenotype_list.html, corresponds to Diagnosis_Name in RPDR.}
#'  \item{dia_code}{string, Diagnosis, diagnosis-related group, or phenotype code, corresponds to Code in RPDR.}
#'  \item{dia_code_type}{string, Standardized classification system or custom grouping associated with the diagnosis code, corresponds to Code_type in RPDR.}
#'  \item{dia_flag}{string, Qualifier for the diagnosis, if any, corresponds to Diagnosis_flag in RPDR.}
#'  \item{dia_enc_num}{string, Unique identifier of the record/visit. This values includes the source system, hospital, and a unique identifier within the source system, corresponds to Encounter_number in RPDR.}
#'  \item{dia_provider}{string, Provider of record for the encounter where the diagnosis was entered, corresponds to Provider in RPDR. Punctuation marks are removed.}
#'  \item{dia_clinic}{string, Specific department/location where the patient encounter took place, corresponds to Clinic in RPDR. Punctuation marks are removed.}
#'  \item{dia_hosp}{string, Facility where the encounter occurred, corresponds to Hospital in RPDR.}
#'  \item{dia_inpatient}{string, Identifies whether the diagnosis was noted during an inpatient or outpatient encounter, Punctuation marks are removed.}
#'  }
#'
#' @encoding UTF-8

NULL
