% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_img_db.R
\encoding{UTF-8}
\name{create_img_db}
\alias{create_img_db}
\title{Create a database of DICOM headers.}
\usage{
create_img_db(
  path,
  ext = "dcm",
  all = TRUE,
  keywords = c("StudyDate", "StudyTime", "SeriesDate", "SeriesTime", "AcquisitionDate",
    "AcquisitionTime", "ConversionType", "Manufacturer", "InstitutionName",
    "InstitutionalDepartmentName", "ReferringPhysicianName", "Modality",
    "ManufacturerModelName", "StudyDescription", "SeriesDescription", "StudyComments",
    "ProtocolName", "RequestedProcedureID", "ViewPosition", "StudyInstanceUID",
    "SeriesInstanceUID", "SOPInstanceUID", "AccessionNumber", "PatientName", "PatientID",
    "IssuerOfPatientID", "PatientBirthDate",      "PatientSex", "PatientAge",
    "PatientSize", "PatientWeight", "StudyID", "SeriesNumber", "AcquisitionNumber",
    "InstanceNumber", "BodyPartExamined", "SliceThickness", "SpacingBetweenSlices",
    "PixelSpacing", "PixelAspectRatio", "Rows", "Columns", "FieldOfViewDimensions",
    "RescaleIntercept", "RescaleSlope", "WindowCenter", "WindowWidth", "BitsAllocated",
    "BitsStored", "PhotometricInterpretation", "KVP", "ExposureTime", "XRayTubeCurrent",
    "ExposureInuAs", "ImageAndFluoroscopyAreaDoseProduct", "FilterType",     
    "ConvolutionKernel", "CTDIvol", "ReconstructionFieldOfView"),
  nThread = 4,
  na = TRUE,
  identical = TRUE
)
}
\arguments{
\item{path}{string vector, full folder path to folder that contains the images.}

\item{ext}{string array, possible file extensions to parse.}

\item{all}{boolean, whether all files in a series should be parsed, or only the first one.}

\item{keywords}{string array, of valid DICOM keywords.}

\item{nThread}{integer, number of threads to use for parsing data.}

\item{na}{boolean, whether to remove columns with only NA values. Defaults to \emph{TRUE}.}

\item{identical}{boolean, whether to remove columns with identical values. Defaults to \emph{TRUE}.}
}
\value{
data.table, with DICOM header information return unchanged. However, the function also provides additional new columns
which help further data manipulations, these are:
\describe{
 \item{time_study}{POSIXct, StudyDate and StudyTime concatentated together to POSIXct.}
 \item{time_series}{POSIXct, SeriesDate and SeriesTime concatentated together to POSIXct.}
 \item{time_acquisition}{POSIXct, AcquisitionDate and AcquisitionTime concatentated together to POSIXct.}
 \item{name_img}{string, PatientName with special characters removed.}
 \item{time_date_of_birth_img}{POSIXct, PatientBirthDate as POSIXct.}
 \item{img_pixel_spacing}{numeric, PixelSpacing value of the first element in the array returned as numerical value.}
 }
}
\description{
The function creates a database of DICOM headers present in a folder structure. Each series should be in its own folder,
but they can be in a nested folder structure. Files where there are also folder present next to them at the same level will not be parsed.
That is the folder structure needs to comply with the DICOM standard.
Be aware that the function requires \href{https://www.python.org}{python} and \href{https://pydicom.github.io}{pydicom} to be installed!
The function cycles through all folders present in the provided path and recursively goes through them,
every subfolder, and extracts the DICOM header information from the files using the
\href{https://pydicom.github.io/pydicom/dev/reference/generated/pydicom.filereader.dcmread.html}{dcmread}
function of the \href{https://pydicom.github.io}{pydicom} package.
The extension of the files can be provided by the \emph{ext} argument,
as DICOM files may have different extensions then that of .dcm. Also, using the \emph{all} boolean argument, you can specify whether
the function provides output for each file, or only for the first file, which is beneficial if you are analyzing multi-slice series,
as all instances have almost all the same header information. Furthermore, using the \emph{keywords} argument you can manually specify
which DICOM keywords you wish to extract. These need to be a valid keyword specified in the
\href{http://dicom.nema.org/medical/dicom/current/output/chtml/part06/chapter_6.html}{DICOM standard}.
}
\examples{
\dontrun{
#Create a database with DICOM header information
all_dicom_headers <- create_img_db(path = "/Users/Test/Data/DICOM/")
all_dicom_headers <- create_img_db(path = "/Users/Test/Data/DICOM/", ext = c("dcm", "DICOM"))
#Create a database with DICOM header information for only IDs and accession numbers
all_dicom_headers <- create_img_db(path = "/Users/Test/Data/DICOM/",
keywords = c("PatientID", "AccessionNumber"))
}
}
