% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors_elements.R
\name{type}
\alias{type}
\title{wrapper around sendKeysToElement() method to generate safe scraping code}
\usage{
type(
  using,
  value,
  name = NULL,
  text,
  text_object,
  new_page = FALSE,
  prev = NULL
)
}
\arguments{
\item{using}{character string specifying locator scheme to use to search elements. Available schemes: "class name", "css selector", "id", "name", "link text", "partial link text", "tag name", "xpath".}

\item{value}{character string specifying the search target.}

\item{name}{character string specifying the object name the RSelenium "wElement" class object should be saved to.If NULL a name will be generated automatically.}

\item{text}{a character vector specifying the text to be typed.}

\item{text_object}{a character string specifying the name of an external object holding the text to be typed. Note that the remDr$sendKeysToElement method only accepts list inputs.}

\item{new_page}{logical indicating if sendKeysToElement() action will result in a change in url.}

\item{prev}{a placeholder for the output of functions being piped into type(). Defaults to NULL and should not be altered.}
}
\value{
a character string defining 'RSelenium' typing instructions that can be pasted into a scraping function.
}
\description{
wrapper around sendKeysToElement() method to generate safe scraping code
}
\examples{
\dontrun{

#navigate to wikipedia, type "Hello" into the search box,  press enter

parsel::go("https://www.wikipedia.org/") \%>>\%
parsel::type(using = "id",
             value = "searchInput",
             name = "searchbox",
             text = c("Hello","\uE007")) \%>>\%
             show()

#navigate to wikipeda, type content stored in external object "x" into search box

parsel::go("https://www.wikipedia.org/") \%>>\%
parsel::type(using = "id",
             value = "searchInput",
             name = "searchbox",
             text_object = "x") \%>>\%
             show()

}
}
