% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines.R
\name{set_engine}
\alias{set_engine}
\title{Declare a computational engine and specific arguments}
\usage{
set_engine(object, engine, ...)
}
\arguments{
\item{object}{A model specification.}

\item{engine}{A character string for the software that should
be used to fit the model. This is highly dependent on the type
of model (e.g. linear regression, random forest, etc.).}

\item{...}{Any optional arguments associated with the chosen computational
engine. These are captured as quosures and can be \code{varying()}.}
}
\value{
An updated model specification.
}
\description{
\code{set_engine()} is used to specify which package or system will be used
to fit the model, along with any arguments specific to that software.
}
\examples{
# First, set general arguments using the standardized names
mod <-
  logistic_reg(penalty = 0.01, mixture = 1/3) \%>\%
  # now say how you want to fit the model and another other options
  set_engine("glmnet", nlambda = 10)
translate(mod, engine = "glmnet")
}
