% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_mars.R, R/bag_tree.R, R/bart.R,
%   R/boost_tree.R, R/c5_rules.R, R/cubist_rules.R, R/decision_tree.R,
%   R/discrim_flexible.R, R/discrim_linear.R, R/discrim_quad.R,
%   R/discrim_regularized.R, R/gen_additive_mod.R, R/linear_reg.R,
%   R/logistic_reg.R, R/mars.R, R/mlp.R, R/multinom_reg.R, R/naive_Bayes.R,
%   R/nearest_neighbor.R, R/pls.R, R/poisson_reg.R, R/proportional_hazards.R,
%   R/rand_forest.R, R/rule_fit.R, R/surv_reg.R, R/survival_reg.R,
%   R/svm_linear.R, R/svm_poly.R, R/svm_rbf.R, R/update.R
\name{update.bag_mars}
\alias{update.bag_mars}
\alias{update.bag_tree}
\alias{update.bart}
\alias{update.boost_tree}
\alias{update.C5_rules}
\alias{update.cubist_rules}
\alias{update.decision_tree}
\alias{update.discrim_flexible}
\alias{update.discrim_linear}
\alias{update.discrim_quad}
\alias{update.discrim_regularized}
\alias{update.gen_additive_mod}
\alias{update.linear_reg}
\alias{update.logistic_reg}
\alias{update.mars}
\alias{update.mlp}
\alias{update.multinom_reg}
\alias{update.naive_Bayes}
\alias{update.nearest_neighbor}
\alias{update.pls}
\alias{update.poisson_reg}
\alias{update.proportional_hazards}
\alias{update.rand_forest}
\alias{update.rule_fit}
\alias{update.surv_reg}
\alias{update.survival_reg}
\alias{update.svm_linear}
\alias{update.svm_poly}
\alias{update.svm_rbf}
\alias{parsnip_update}
\title{Updating a model specification}
\usage{
\method{update}{bag_mars}(
  object,
  parameters = NULL,
  num_terms = NULL,
  prod_degree = NULL,
  prune_method = NULL,
  fresh = FALSE,
  ...
)

\method{update}{bag_tree}(
  object,
  parameters = NULL,
  cost_complexity = NULL,
  tree_depth = NULL,
  min_n = NULL,
  class_cost = NULL,
  fresh = FALSE,
  ...
)

\method{update}{bart}(
  object,
  parameters = NULL,
  trees = NULL,
  prior_terminal_node_coef = NULL,
  prior_terminal_node_expo = NULL,
  prior_outcome_range = NULL,
  fresh = FALSE,
  ...
)

\method{update}{boost_tree}(
  object,
  parameters = NULL,
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  tree_depth = NULL,
  learn_rate = NULL,
  loss_reduction = NULL,
  sample_size = NULL,
  stop_iter = NULL,
  fresh = FALSE,
  ...
)

\method{update}{C5_rules}(
  object,
  parameters = NULL,
  trees = NULL,
  min_n = NULL,
  fresh = FALSE,
  ...
)

\method{update}{cubist_rules}(
  object,
  parameters = NULL,
  committees = NULL,
  neighbors = NULL,
  max_rules = NULL,
  fresh = FALSE,
  ...
)

\method{update}{decision_tree}(
  object,
  parameters = NULL,
  cost_complexity = NULL,
  tree_depth = NULL,
  min_n = NULL,
  fresh = FALSE,
  ...
)

\method{update}{discrim_flexible}(
  object,
  num_terms = NULL,
  prod_degree = NULL,
  prune_method = NULL,
  fresh = FALSE,
  ...
)

\method{update}{discrim_linear}(
  object,
  penalty = NULL,
  regularization_method = NULL,
  fresh = FALSE,
  ...
)

\method{update}{discrim_quad}(object, regularization_method = NULL, fresh = FALSE, ...)

\method{update}{discrim_regularized}(
  object,
  frac_common_cov = NULL,
  frac_identity = NULL,
  fresh = FALSE,
  ...
)

\method{update}{gen_additive_mod}(
  object,
  select_features = NULL,
  adjust_deg_free = NULL,
  parameters = NULL,
  fresh = FALSE,
  ...
)

\method{update}{linear_reg}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)

\method{update}{logistic_reg}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)

\method{update}{mars}(
  object,
  parameters = NULL,
  num_terms = NULL,
  prod_degree = NULL,
  prune_method = NULL,
  fresh = FALSE,
  ...
)

\method{update}{mlp}(
  object,
  parameters = NULL,
  hidden_units = NULL,
  penalty = NULL,
  dropout = NULL,
  epochs = NULL,
  activation = NULL,
  learn_rate = NULL,
  fresh = FALSE,
  ...
)

\method{update}{multinom_reg}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)

\method{update}{naive_Bayes}(object, smoothness = NULL, Laplace = NULL, fresh = FALSE, ...)

\method{update}{nearest_neighbor}(
  object,
  parameters = NULL,
  neighbors = NULL,
  weight_func = NULL,
  dist_power = NULL,
  fresh = FALSE,
  ...
)

\method{update}{pls}(
  object,
  parameters = NULL,
  predictor_prop = NULL,
  num_comp = NULL,
  fresh = FALSE,
  ...
)

\method{update}{poisson_reg}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)

\method{update}{proportional_hazards}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)

\method{update}{rand_forest}(
  object,
  parameters = NULL,
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  fresh = FALSE,
  ...
)

\method{update}{rule_fit}(
  object,
  parameters = NULL,
  mtry = NULL,
  trees = NULL,
  min_n = NULL,
  tree_depth = NULL,
  learn_rate = NULL,
  loss_reduction = NULL,
  sample_size = NULL,
  penalty = NULL,
  fresh = FALSE,
  ...
)

\method{update}{surv_reg}(object, parameters = NULL, dist = NULL, fresh = FALSE, ...)

\method{update}{survival_reg}(object, parameters = NULL, dist = NULL, fresh = FALSE, ...)

\method{update}{svm_linear}(
  object,
  parameters = NULL,
  cost = NULL,
  margin = NULL,
  fresh = FALSE,
  ...
)

\method{update}{svm_poly}(
  object,
  parameters = NULL,
  cost = NULL,
  degree = NULL,
  scale_factor = NULL,
  margin = NULL,
  fresh = FALSE,
  ...
)

\method{update}{svm_rbf}(
  object,
  parameters = NULL,
  cost = NULL,
  rbf_sigma = NULL,
  margin = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{object}{A model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. Use \strong{either} \code{parameters} \strong{or} the main arguments
directly when updating. If the main arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{num_terms}{The number of features that will be retained in the
final model, including the intercept.}

\item{prod_degree}{The highest possible interaction degree.}

\item{prune_method}{The pruning method.}

\item{fresh}{A logical for whether the arguments should be
modified in-place or replaced wholesale.}

\item{...}{Not used for \code{update()}.}

\item{cost_complexity}{A positive number for the the cost/complexity
parameter (a.k.a. \code{Cp}) used by CART models (specific engines only).}

\item{tree_depth}{An integer for maximum depth of the tree.}

\item{min_n}{An integer for the minimum number of data points
in a node that are required for the node to be split further.}

\item{class_cost}{A non-negative scalar for a class cost (where a cost of 1
means no extra cost). This is useful for when the first level of the outcome
factor is the minority class. If this is not the case, values between zero
and one can be used to bias to the second level of the factor.}

\item{trees}{An integer for the number of trees contained in
the ensemble.}

\item{prior_terminal_node_coef}{A coefficient for the prior probability that
a node is a terminal node.}

\item{prior_terminal_node_expo}{An exponent in the prior probability that
a node is a terminal node.}

\item{prior_outcome_range}{A positive value that defines the width of a prior
that the predicted outcome is within a certain range. For regression it is
related to the observed range of the data; the prior is the number of standard
deviations of a Gaussian distribution defined by the observed range of the
data. For classification, it is defined as the range of +/-3 (assumed to be
on the logit scale). The default value is 2.}

\item{mtry}{A number for the number (or proportion) of predictors that will
be randomly sampled at each split when creating the tree models
(specific engines only)}

\item{learn_rate}{A number for the rate at which the boosting algorithm adapts
from iteration-to-iteration (specific engines only). This is sometimes referred to
as the shrinkage parameter.}

\item{loss_reduction}{A number for the reduction in the loss function required
to split further (specific engines only).}

\item{sample_size}{A number for the number (or proportion) of data that is
exposed to the fitting routine. For \code{xgboost}, the sampling is done at
each iteration while \code{C5.0} samples once during training.}

\item{stop_iter}{The number of iterations without improvement before
stopping (specific engines only).}

\item{committees}{A non-negative integer (no greater than 100) for the number
of members of the ensemble.}

\item{neighbors}{An integer between zero and nine for the number of training
set instances that are used to adjust the model-based prediction.}

\item{max_rules}{The largest number of rules.}

\item{penalty}{An non-negative number representing the amount of
regularization used by some of the engines.}

\item{regularization_method}{A character string for the type of regularized
estimation. Possible values are: "\code{diagonal}", "\code{min_distance}",
"\code{shrink_cov}", and "\code{shrink_mean}" (\code{sparsediscrim} engine only).}

\item{frac_common_cov, frac_identity}{Numeric values between zero and one.}

\item{select_features}{\code{TRUE} or \code{FALSE.} If \code{TRUE}, the model has the
ability to eliminate a predictor (via penalization). Increasing
\code{adjust_deg_free} will increase the likelihood of removing predictors.}

\item{adjust_deg_free}{If \code{select_features = TRUE}, then acts as a multiplier
for smoothness. Increase this beyond 1 to produce smoother models.}

\item{mixture}{A number between zero and one (inclusive) denoting the
proportion of L1 regularization (i.e. lasso) in the model.
\itemize{
\item \code{mixture = 1} specifies a pure lasso model,
\item \code{mixture = 0}  specifies a ridge regression model, and
\item \verb{0 < mixture < 1} specifies an elastic net model, interpolating lasso and ridge.
}

Available for specific engines only.}

\item{hidden_units}{An integer for the number of units in the hidden model.}

\item{dropout}{A number between 0 (inclusive) and 1 denoting the proportion
of model parameters randomly set to zero during model training.}

\item{epochs}{An integer for the number of training iterations.}

\item{activation}{A single character string denoting the type of relationship
between the original predictors and the hidden unit layer. The activation
function between the hidden and output layers is automatically set to either
"linear" or "softmax" depending on the type of outcome. Possible values are:
"linear", "softmax", "relu", and "elu"}

\item{smoothness}{An non-negative number representing the the relative
smoothness of the class boundary. Smaller examples result in model flexible
boundaries and larger values generate class boundaries that are less
adaptable}

\item{Laplace}{A non-negative value for the Laplace correction to smoothing
low-frequency counts.}

\item{weight_func}{A \emph{single} character for the type of kernel function used
to weight distances between samples. Valid choices are: \code{"rectangular"},
\code{"triangular"}, \code{"epanechnikov"}, \code{"biweight"}, \code{"triweight"},
\code{"cos"}, \code{"inv"}, \code{"gaussian"}, \code{"rank"}, or \code{"optimal"}.}

\item{dist_power}{A single number for the parameter used in
calculating Minkowski distance.}

\item{predictor_prop}{The maximum proportion of original predictors that can
have \emph{non-zero} coefficients for each PLS component (via regularization).
This value is used for all PLS components for X.}

\item{num_comp}{The number of PLS components to retain.}

\item{dist}{A character string for the probability distribution of the
outcome. The default is "weibull".}

\item{cost}{A positive number for the cost of predicting a sample within
or on the wrong side of the margin}

\item{margin}{A positive number for the epsilon in the SVM insensitive
loss function (regression only)}

\item{degree}{A positive number for polynomial degree.}

\item{scale_factor}{A positive number for the polynomial scaling factor.}

\item{rbf_sigma}{A positive number for radial basis function.}
}
\value{
An updated model specification.
}
\description{
If parameters of a model specification need to be modified, \code{update()} can
be used in lieu of recreating the object from scratch.
}
\examples{

# ------------------------------------------------------------------------------

model <- C5_rules(trees = 10, min_n = 2)
model
update(model, trees = 1)
update(model, trees = 1, fresh = TRUE)

# ------------------------------------------------------------------------------

model <- cubist_rules(committees = 10, neighbors = 2)
model
update(model, committees = 1)
update(model, committees = 1, fresh = TRUE)
model <- pls(predictor_prop =  0.1)
model
update(model, predictor_prop = 1)
update(model, predictor_prop = 1, fresh = TRUE)
# ------------------------------------------------------------------------------

model <- rule_fit(trees = 10, min_n = 2)
model
update(model, trees = 1)
update(model, trees = 1, fresh = TRUE)
model <- boost_tree(mtry = 10, min_n = 3)
model
update(model, mtry = 1)
update(model, mtry = 1, fresh = TRUE)

param_values <- tibble::tibble(mtry = 10, tree_depth = 5)

model \%>\% update(param_values)
model \%>\% update(param_values, mtry = 3)

param_values$verbose <- 0
# Fails due to engine argument
# model \%>\% update(param_values)

model <- linear_reg(penalty = 10, mixture = 0.1)
model
update(model, penalty = 1)
update(model, penalty = 1, fresh = TRUE)

}
