% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_Bayes_naivebayes.R
\name{details_naive_Bayes_naivebayes}
\alias{details_naive_Bayes_naivebayes}
\title{Naive Bayes models via naivebayes}
\description{
\code{\link[naivebayes:naive_bayes]{naivebayes::naive_bayes()}} fits a model that uses Bayes' theorem to compute
the probability of each class, given the predictor values.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has 2 tuning parameter:
\itemize{
\item \code{smoothness}: Kernel Smoothness (type: double, default: 1.0)
\item \code{Laplace}: Laplace Correction (type: double, default: 0.0)
}

Note that the engine argument \code{usekernel} is set to \code{TRUE} by default
when using the \code{naivebayes} engine.
}

\subsection{Translation from parsnip to the original package}{

The \strong{discrim} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(discrim)

naive_Bayes(smoothness = numeric(0), Laplace = numeric(0)) \%>\% 
  set_engine("naivebayes") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Naive Bayes Model Specification (classification)
## 
## Main Arguments:
##   smoothness = numeric(0)
##   Laplace = numeric(0)
## 
## Computational engine: naivebayes 
## 
## Model fit template:
## naivebayes::naive_bayes(x = missing_arg(), y = missing_arg(), 
##     adjust = numeric(0), laplace = numeric(0), usekernel = TRUE)
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

The columns for qualitative predictors should always be represented as
factors (as opposed to dummy/indicator variables). When the predictors
are factors, the underlying code treats them as multinomial data and
appropriately computes their conditional distributions.

For count data, integers can be estimated using a Poisson distribution
if the argument \code{usepoisson = TRUE} is passed as an engine argument.

Variance calculations are used in these computations so \emph{zero-variance}
predictors (i.e., with a single unique value) should be eliminated
before fitting the model.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}.
Springer.
}
}
}
\keyword{internal}
