% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitioners.R
\name{replace_partitioner}
\alias{replace_partitioner}
\title{Replace the director, metric, or reducer for a partitioner}
\usage{
replace_partitioner(partitioner, direct = NULL, measure = NULL, reduce = NULL)
}
\arguments{
\item{partitioner}{a \code{partitioner}}

\item{direct}{a function that directs, possibly created by \code{\link[=as_director]{as_director()}}}

\item{measure}{a function that measures, possibly created by \code{\link[=as_measure]{as_measure()}}}

\item{reduce}{a function that reduces, possibly created by \code{\link[=as_reducer]{as_reducer()}}}
}
\value{
a \code{partitioner}
}
\description{
Replace the director, metric, or reducer for a partitioner
}
\examples{

replace_partitioner(
  part_icc,
  reduce = as_reducer(rowMeans)
)

}
\seealso{
Other partitioners: 
\code{\link{as_partitioner}()},
\code{\link{part_icc}()},
\code{\link{part_kmeans}()},
\code{\link{part_minr2}()},
\code{\link{part_pc1}()},
\code{\link{part_stdmi}()}
}
\concept{partitioners}
