% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_country_code.R
\name{as_country_code}
\alias{as_country_code}
\title{Convert standardized country names to country codes}
\usage{
as_country_code(x, from, to = "iso2c", factor = is.factor(x))
}
\arguments{
\item{x}{A character, factor, or numeric vector of country names or codes}

\item{from}{Format from which to convert. See Details for more options.}

\item{to}{Code format to which to convert. Defaults to \code{"iso2c"}; see
\code{\link{codes}} for more options.}

\item{factor}{If \code{TRUE}, returns factor instead of character vector.}
}
\value{
A vector of country codes. Warns if new \code{NA} values are added.
}
\description{
\code{as_country_code} converts a vector of standardized country names or codes to
country codes
}
\details{
\code{as_country_code} takes a character, factor, or numeric vector of country
names or codes to translate into the specified code format. The default for
\code{to} is \code{"iso2c"}, the ISO 3166-1 Alpha-2 character codes, but many
alternatives are available.

Several non-unique codes are available as well, including \code{"continent"},
\code{"is_independent"}, ISO 4217 currency codes, etc. Backwards conversion will
not work for such cases.

If converting to country names, use \code{\link[=as_country_name]{as_country_name()}}, which offers
control of short and variant forms.

See \code{\link{codes}} for all options, or run \code{DT::datatable(codes)} for a
searchable widget.
}
\examples{
# Codifies standardized names
as_country_code(c("US", "Taiwan", "Myanmar", "Kosovo", "South Korea"), from = "en")

# Translates codes; if passed a factor, returns a releveled one
as_country_code(factor(c("SAH", "PCN", "OMA", "JPN")),
                from = "fifa", to = "iso4217_3c")

}
