% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/passt.R
\name{run_sim}
\alias{run_sim}
\title{Run simulations}
\usage{
run_sim(patterns, frequency, duration, lrate_onset, lrate_drop_time,
  lrate_drop_perc, n_runs = 100, n_output_units = ncol(patterns),
  pulses_per_second = 1)
}
\arguments{
\item{patterns}{matrix with input patterns, one row is one pattern}

\item{frequency}{presentation frequency for each pattern in the
matrix}

\item{duration}{presentation duration for each pattern in the
matrix}

\item{lrate_onset}{learning rate at the onset of a stimulus}

\item{lrate_drop_time}{point at which the learning rate drops, must
be lower than duration}

\item{lrate_drop_perc}{how much the learning rate drops at
lrate_drop_time}

\item{n_runs}{number of simulations to be run, default is 100}

\item{n_output_units}{number of output units, defaults to number of
input units}

\item{pulses_per_second}{how many time steps should be simulated
per second}
}
\value{
list with following elements
\itemize{
  \item output: the sum of the activation strengths of the
    output units for each input pattern
  \item weight_matrix: final weight_matrix
  \item pres_matrix: presentation matrix
}
}
\description{
Runs several simulations and returns output activation for each
simulation and each input pattern
}
\examples{
run_sim(diag(10), 1:10, 10:1, 0.05, 2, 0.2)
}
\seealso{
\code{\link{run_exp}}
}
