% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment_functions.R
\name{summarize_enrichment_results}
\alias{summarize_enrichment_results}
\title{Summarize Enrichment Results}
\usage{
summarize_enrichment_results(enrichment_res, list_active_snw_genes = FALSE)
}
\arguments{
\item{enrichment_res}{a dataframe of combined enrichment results. Columns are: \describe{
  \item{ID}{ID of the enriched term}
  \item{Term_Description}{Description of the enriched term}
  \item{Fold_Enrichment}{Fold enrichment value for the enriched term}
  \item{p_value}{p value of enrichment}
  \item{adj_p}{adjusted p value of enrichment}
  \item{non_Signif_Snw_Genes (OPTIONAL)}{the non-significant active subnetwork genes, comma-separated}
}}

\item{list_active_snw_genes}{boolean value indicating whether or not to report
the non-significant active subnetwork genes for the active subnetwork which was enriched for
the given term with the lowest p value (default = \code{FALSE})}
}
\value{
a dataframe of summarized enrichment results (over multiple iterations). Columns are: \describe{
  \item{ID}{ID of the enriched term}
  \item{Term_Description}{Description of the enriched term}
  \item{Fold_Enrichment}{Fold enrichment value for the enriched term}
  \item{occurrence}{the number of iterations that the given term was found to enriched over all iterations}
  \item{lowest_p}{the lowest adjusted-p value of the given term over all iterations}
  \item{highest_p}{the highest adjusted-p value of the given term over all iterations}
  \item{non_Signif_Snw_Genes (OPTIONAL)}{the non-significant active subnetwork genes, comma-separated}
}
}
\description{
Summarize Enrichment Results
}
\examples{
\dontrun{
summarize_enrichment_results(enrichment_res)
}
}
