% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/paths.R
\name{copy_dir}
\alias{copy_dir}
\alias{dir_copy}
\title{Copy the contents of a directory}
\usage{
copy_dir(source_dir, target_dir, pattern = NULL, overwrite = FALSE,
  recursive = TRUE)

dir_copy(...)
}
\arguments{
\item{source_dir}{String of directory to copy from.}

\item{target_dir}{String of directory to copy to.}

\item{pattern}{String regex or \code{NULL}. A filter for filenames, passed
to \code{dir}.}

\item{overwrite}{Logical value.  Should existing files be overwritten?}

\item{recursive}{Logical value.  Should subdirectories and their contents
be copied?}

\item{...}{Passed from the deprecated \code{dir_copy} to \code{copy_dir}.}
}
\value{
A logical vector of whether or not each file was successfully
copied is invisibly returned.
}
\description{
Copies the contents of a directory, possibly recursively.
}
\note{
Target directories that don't exist are created, silently (assuming
write permission).
}
\examples{
\dontrun{
#Copy subdirs by default
copy_dir(R.home("etc"), file.path(tempdir(), "etc"))
#Just copy the top level
copy_dir(R.home("etc"), file.path(tempdir(), "etc2"), recursive = FALSE)
#Now copy deeper levels, without overwriting.
copy_dir(R.home("etc"), file.path(tempdir(), "etc2"), overwrite = FALSE)
#Cleanup
unlink(file.path(tempdir(), "etc"), recursive = TRUE)
unlink(file.path(tempdir(), "etc2"), recursive = TRUE)
}
}
\seealso{
\code{\link[base]{basename}}
}

