% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_subjectProfileCombine.R
\name{getTimeLimSubjectProfilePlots}
\alias{getTimeLimSubjectProfilePlots}
\title{Get the limits to set for the subject profile plots,
depending on the alignment policy set.}
\usage{
getTimeLimSubjectProfilePlots(
  listPlots,
  timeAlign = "all",
  timeAlignPerSubject = "none"
)
}
\arguments{
\item{listPlots}{list of list of \code{subjectProfile[X]Plot} plots}

\item{timeAlign}{Character vector with time alignment across modules/subjects, either:
\itemize{
\item{'all' (by default): }{all plots have the same time limits}
\item{'none': }{each of the plot (module*subject) has its own time limits}
\item{character vector with names of the modules which
should have the same time limits
(should correspond to the names of \code{listPlots})}
}}

\item{timeAlignPerSubject}{Character vector, specifying if the plots
should be aligned (or not) across subjects
\itemize{
\item{'none' (by default): }{all modules to align
have the same time limit across subjects}
\item{'all': }{all modules to align
 have different time limits per subject}
\item{character vector with subset of the modules to align per subject
(should correspond to the names of \code{listPlots})}
}
Only the modules already specified in \code{timeAlign}
can be aligned by subject.}
}
\value{
Time limits, as a numeric vector of length 2.
If time limits should be set by module, named list
with time limits by module.
If time limits should be set by module and subject, nested list
with time limits 1) by module 2) by subject.\cr
The names of the list contains the module/subject name extracted
from the names of \code{listPlots}.\cr
The time limits are only returned if they will need to be explicitly set
for a plot. Otherwise, NULL is returned.
}
\description{
These limits are extracted from specified \code{timeLim} for each
module (stored in the \code{attributes()$metaData$timeLim}), 
and if empty for all modules: from the maximal range
of the x-coordinates across all plots.
}
\author{
Laure Cougnaud
}
