% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTarget.R
\name{createTarget}
\alias{createTarget}
\title{Create a target image (RasterStack) from a polygon.}
\usage{
createTarget(
  outline,
  image,
  res = 300,
  colorFill = "black",
  colorBG = "white",
  sigma = 10,
  plot = FALSE
)
}
\arguments{
\item{outline}{xy coordinates that define outline.}

\item{image}{Image imported as RasterStack used in the analysis. This is used to extract
the extent and dimensions for the raster layers.}

\item{res}{Resolution for RasterStack (default = 300).}

\item{colorFill}{Color for the fill of the polygon (default = 'black').}

\item{colorBG}{Color for the background (default = 'white').}

\item{sigma}{Size of sigma for Gaussian blurring (default = 10).}

\item{plot}{Whether to plot the created target image (default = FALSE).}
}
\value{
RasterStack
}
\description{
Create a target image (RasterStack) from a polygon.
}
\examples{

\dontrun{
outline_BC0077 <- read.table(paste(system.file("extdata",  package = 'patternize'),
'/BC0077_outline.txt', sep=''), header = FALSE)

data(imageList)

target <- createTarget(outline_BC0077, imageList[[1]], plot =  TRUE)
}

}
