% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagepie.R
\name{imagepie}
\alias{imagepie}
\title{Plot a pie chart with slices filled with png and jpeg images.}
\usage{
imagepie(group, pct, label, label.size = 4, label.color = "black",
  label.distance = 1.35, pattern.type, frame.color = "black",
  frame.size = 1)
}
\arguments{
\item{group}{a vector of strings, containing the names of each slice.}

\item{pct}{a vector of non-negative numbers, containing percentages of each group.
The numbers must sum up to 100.}

\item{label}{a vector of strings, giving the names for the slices shown in the pie chart.}

\item{label.size}{the font size of labels shown in the pie chart.}

\item{label.color}{the color of labels shown in the pie chart.}

\item{label.distance}{the distance of labels from the border of the pie chart.}

\item{pattern.type}{a list of objects returned by \code{readPNG} and \code{readJPEG} used to fill slices.}

\item{frame.color}{the color for the borders of slices.}

\item{frame.size}{a numeric value, the line size for the borders of slices.}
}
\value{
A ggplot object.
}
\description{
The \code{imagepie} function is a tool for creating versatile pie charts 
by filling the slices with external png and jpeg images.
}
\details{
\code{imagepie} function offers flexible ways in doing pie charts.
}
\examples{
library(patternplot)
library(jpeg)
Tomatoes <-  readJPEG(system.file("img", "tomatoes.jpg", package="patternplot"))
Peas <- readJPEG(system.file("img", "peas.jpg", package="patternplot"))
Peppers <-  readJPEG(system.file("img", "peppers.jpg", package="patternplot"))

#Example 1
data <- read.csv(system.file("extdata", "vegetables.csv", package="patternplot"))
pattern.type<-list(Tomatoes,Peas,Peppers)
imagepie(group=data$group,pct=data$pct,label=data$label,pattern.type=pattern.type,
         label.distance=1.25,frame.color='burlywood4', frame.size=0.8, label.size=6, 
         label.color='forestgreen')


}
\seealso{
Function \code{patternpie}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
