% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageboxplot.R
\name{imageboxplot}
\alias{imageboxplot}
\title{Plot a boxplot with boxes filled with png and jpeg images.}
\usage{
imageboxplot(data, x, y, group = NULL, xlab = "", ylab = "",
  label.size = 3.5, pattern.type, frame.color = "black",
  linetype = "solid", frame.size = 1, outlier.shape = 21,
  outlier.color = "black", outlier.size = 1, legend.type = "h",
  legend.h = 6, legend.x.pos = 1.1, legend.y.pos = 0.49,
  legend.w = 0.2, legend.pixel = 0.3)
}
\arguments{
\item{data}{the data to be used.}

\item{x}{the variable used on x axis.}

\item{y}{the variable used on y axis.}

\item{group}{the variable used as the second grouping variable on x axis.}

\item{xlab}{a character string to give x axis label.}

\item{ylab}{a character string to give y axis label.}

\item{label.size}{the font size of legend labels.}

\item{pattern.type}{a list of objects returned by \code{readPNG} and \code{readJPEG} used to fill boxplots.}

\item{frame.color}{the color for the borders of boxplots.}

\item{linetype}{the linetype for the borders of boxplots.}

\item{frame.size}{a numeric value, the line size for the borders of boxplots.}

\item{outlier.shape}{the shape of outlier dots.}

\item{outlier.color}{the color of outlier dots.}

\item{outlier.size}{the size of outlier dots.}

\item{legend.type}{if legend.type='h', the layout of legends is horizontal; if legend.type='v', the layout of legends is vertical.}

\item{legend.h}{a numeric value to fine-tune the width of legend boxes on y axis.}

\item{legend.x.pos}{a numeric value to change the position of legend text on x axis.}

\item{legend.y.pos}{a numeric value to change the position of legend text on y axis.}

\item{legend.w}{a numeric value to change the width of legends.}

\item{legend.pixel}{a numeric value to change the pixel of legend boxes.}
}
\value{
A ggplot object.
}
\description{
The \code{imageboxplot} function is a tool for creating versatile boxplots 
by filling the boxplots with external png and jpeg images.
}
\details{
\code{imageboxplot} function offers flexible ways of doing boxplots.
}
\examples{
library(patternplot)
library(jpeg)
library(ggplot2)

Orange<-readJPEG(system.file("img", "oranges.jpg", package="patternplot"))
Strawberry <-readJPEG(system.file("img", "strawberries.jpg", package="patternplot"))
Watermelon<-readJPEG(system.file("img", "watermelons.jpg", package="patternplot"))

#Example 1
data <- read.csv(system.file("extdata", "fruits.csv", package="patternplot"))
x<-data$Fruit
y<-data$Weight
group<-data$Store
pattern.type<-list(Orange, Strawberry, Watermelon)
imageboxplot(data,x,y,group=NULL,pattern.type=pattern.type,
frame.color=c('orange', 'darkred', 'darkgreen'),ylab='Weight, Pounds')
}
\seealso{
Function \code{patternboxplot}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
