% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggspec.R
\name{aggspec}
\alias{aggspec}
\title{Aggregate reflectance spectra}
\usage{
aggspec(rspecdata, by = NULL, FUN = mean, trim = TRUE, na.rm = FALSE)
}
\arguments{
\item{rspecdata}{(required) data frame, possibly of class \code{rspec}
containing the spectra to be manipulated. If it contains a wavelength column 
named "wl", that column will be ignored.}

\item{by}{(required) either a single value specifying the range of spectra within
the data frame to be combined (for example, \code{by} = 3 indicates the function
will be applied to groups of 3 consecutive columns in the spectra data frame); 
a vector containing identifications for the columns in the spectra data frame
(in which case the function will be applied to each group of spectra sharing the
same identification); or a list of vectors, e.g., \code{by = list(sex, species)}.}

\item{FUN}{the function to be applied to the groups of spectra. (defaults to \code{\link{mean}})}

\item{trim}{logical. if \code{TRUE} (default), the function will try to identify and 
remove numbers at the end of the names of the columns in the new rspec object.}

\item{na.rm}{should NAs be reomved? Defaults to \code{FALSE}.}
}
\value{
A data frame of class \code{rspec} containing the spectra after applying the aggregating function.
}
\description{
Combines spectra (by taking the average, for example) according to 
an index or a vector of identities.
}
\examples{
\dontrun{
data(teal)

# Average every two spectra
teal.sset1 <- aggspec(teal, by = 2)
plot(teal.sset1)

# Create factor and average spectra by levels 'a' and 'b'
ind <- rep(c('a', 'b'), times = 6)
teal.sset2 <- aggspec(teal, by = ind)

plot(teal.sset2) 
}

}
\references{
Montgomerie R (2006) Analyzing colors. In: Hill G, McGraw K (eds) 
Bird coloration. Harvard University Press, Cambridge, pp 90-147.
}
\author{
Chad Eliason \email{cme16@zips.uakron.edu}
}
