% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_update_shard_count}
\alias{kinesis_update_shard_count}
\title{Updates the shard count of the specified stream to the specified number
of shards}
\usage{
kinesis_update_shard_count(StreamName, TargetShardCount, ScalingType)
}
\arguments{
\item{StreamName}{[required] The name of the stream.}

\item{TargetShardCount}{[required] The new number of shards. This value has the following default limits.
By default, you cannot do the following:
\itemize{
\item Set this value to more than double your current shard count for a
stream.
\item Set this value below half your current shard count for a stream.
\item Set this value to more than 500 shards in a stream (the default
limit for shard count per stream is 500 per account per region),
unless you request a limit increase.
\item Scale a stream with more than 500 shards down unless you set this
value to less than 500 shards.
}}

\item{ScalingType}{[required] The scaling type. Uniform scaling creates shards of equal size.}
}
\description{
Updates the shard count of the specified stream to the specified number
of shards.

Updating the shard count is an asynchronous operation. Upon receiving
the request, Kinesis Data Streams returns immediately and sets the
status of the stream to \code{UPDATING}. After the update is complete,
Kinesis Data Streams sets the status of the stream back to \code{ACTIVE}.
Depending on the size of the stream, the scaling action could take a few
minutes to complete. You can continue to read and write data to your
stream while its status is \code{UPDATING}.

To update the shard count, Kinesis Data Streams performs splits or
merges on individual shards. This can cause short-lived shards to be
created, in addition to the final shards. These short-lived shards count
towards your total shard limit for your account in the Region.

When using this operation, we recommend that you specify a target shard
count that is a multiple of 25\\% (25\\%, 50\\%, 75\\%, 100\\%). You can specify
any target value within your shard limit. However, if you specify a
target that isn't a multiple of 25\\%, the scaling action might take
longer to complete.

This operation has the following default limits. By default, you cannot
do the following:
\itemize{
\item Scale more than ten times per rolling 24-hour period per stream
\item Scale up to more than double your current shard count for a stream
\item Scale down below half your current shard count for a stream
\item Scale up to more than 500 shards in a stream
\item Scale a stream with more than 500 shards down unless the result is
less than 500 shards
\item Scale up to more than the shard limit for your account
}

For the default limits for an AWS account, see \href{https://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html}{Streams Limits}
in the \emph{Amazon Kinesis Data Streams Developer Guide}. To request an
increase in the call rate limit, the shard limit for this API, or your
overall shard limit, use the limits form.
}
\section{Request syntax}{
\preformatted{svc$update_shard_count(
  StreamName = "string",
  TargetShardCount = 123,
  ScalingType = "UNIFORM_SCALING"
)
}
}

\keyword{internal}
