% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_list_instances}
\alias{emr_list_instances}
\title{Provides information for all active EC2 instances and EC2 instances
terminated in the last 30 days, up to a maximum of 2,000}
\usage{
emr_list_instances(ClusterId, InstanceGroupId, InstanceGroupTypes,
  InstanceFleetId, InstanceFleetType, InstanceStates, Marker)
}
\arguments{
\item{ClusterId}{[required] The identifier of the cluster for which to list the instances.}

\item{InstanceGroupId}{The identifier of the instance group for which to list the instances.}

\item{InstanceGroupTypes}{The type of instance group for which to list the instances.}

\item{InstanceFleetId}{The unique identifier of the instance fleet.}

\item{InstanceFleetType}{The node type of the instance fleet. For example MASTER, CORE, or TASK.}

\item{InstanceStates}{A list of instance states that will filter the instances returned with
this request.}

\item{Marker}{The pagination token that indicates the next set of results to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Instances = list(
    list(
      Id = "string",
      Ec2InstanceId = "string",
      PublicDnsName = "string",
      PublicIpAddress = "string",
      PrivateDnsName = "string",
      PrivateIpAddress = "string",
      Status = list(
        State = "AWAITING_FULFILLMENT"|"PROVISIONING"|"BOOTSTRAPPING"|"RUNNING"|"TERMINATED",
        StateChangeReason = list(
          Code = "INTERNAL_ERROR"|"VALIDATION_ERROR"|"INSTANCE_FAILURE"|"BOOTSTRAP_FAILURE"|"CLUSTER_TERMINATED",
          Message = "string"
        ),
        Timeline = list(
          CreationDateTime = as.POSIXct(
            "2015-01-01"
          ),
          ReadyDateTime = as.POSIXct(
            "2015-01-01"
          ),
          EndDateTime = as.POSIXct(
            "2015-01-01"
          )
        )
      ),
      InstanceGroupId = "string",
      InstanceFleetId = "string",
      Market = "ON_DEMAND"|"SPOT",
      InstanceType = "string",
      EbsVolumes = list(
        list(
          Device = "string",
          VolumeId = "string"
        )
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Provides information for all active EC2 instances and EC2 instances
terminated in the last 30 days, up to a maximum of 2,000. EC2 instances
in any of the following states are considered active:
AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.
}
\section{Request syntax}{
\preformatted{svc$list_instances(
  ClusterId = "string",
  InstanceGroupId = "string",
  InstanceGroupTypes = list(
    "MASTER"|"CORE"|"TASK"
  ),
  InstanceFleetId = "string",
  InstanceFleetType = "MASTER"|"CORE"|"TASK",
  InstanceStates = list(
    "AWAITING_FULFILLMENT"|"PROVISIONING"|"BOOTSTRAPPING"|"RUNNING"|"TERMINATED"
  ),
  Marker = "string"
)
}
}

\keyword{internal}
