% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_check_schema_version_validity}
\alias{glue_check_schema_version_validity}
\title{Validates the supplied schema}
\usage{
glue_check_schema_version_validity(DataFormat, SchemaDefinition)
}
\arguments{
\item{DataFormat}{[required] The data format of the schema definition. Currently only \code{AVRO} is
supported.}

\item{SchemaDefinition}{[required] The definition of the schema that has to be validated.}
}
\value{
A list with the following syntax:\preformatted{list(
  Valid = TRUE|FALSE,
  Error = "string"
)
}
}
\description{
Validates the supplied schema. This call has no side effects, it simply
validates using the supplied schema using \code{DataFormat} as the format.
Since it does not take a schema set name, no compatibility checks are
performed.
}
\section{Request syntax}{
\preformatted{svc$check_schema_version_validity(
  DataFormat = "AVRO",
  SchemaDefinition = "string"
)
}
}

\keyword{internal}
